<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/mainrestriction/main_restriction_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';

require_once $GLOBALS["RootFiles"] . '/apitobackend/geo/geo.php';

class MAINRESTRICTION_ADMIN
{
    public static function CheckFirewallForDownGrade($domainID, $plan, $newplan)
    {

        $CurrentPlanCountOfRules = ReturnPlans()[$plan]["firewall"];

        $NewPlanCountOfRules = ReturnPlans()[$newplan]["firewall"];

        $CurrentPlanmaxIpInFirewall = ReturnPlans()[$plan]["maxipinfirewall"];
        $NewPlanmaxIpInFirewall = ReturnPlans()[$newplan]["maxipinfirewall"];

        $MainRestriction = "SELECT * FROM `tbl_main_restriction`,tbl_websites,tbl_domains WHERE domain_id=ws_domainid_fk and `mi_websiteid`=wsid and ws_domainid_fk=" . $domainID;
        $IpRules = "SELECT * FROM tbl_websites,tbl_subfolder,tbl_subdfolder_ipmanagement,tbl_domains WHERE domain_id=ws_domainid_fk and sfim_sf_id_fk=subfolder_id and sf_ws_id_fk=wsid  and ws_domainid_fk=" . $domainID;
        $CountryRules = "SELECT * FROM tbl_websites,tbl_subfolder,tbl_subdfolder_countrymanagement,tbl_domains WHERE domain_id=ws_domainid_fk and  sfcm_sf_id_fk=subfolder_id and sf_ws_id_fk=wsid  and ws_domainid_fk=" . $domainID;

        $conn = GetConnection();
        $resultMainRestriction = $conn->query($MainRestriction);
        $resultIpRules = $conn->query($IpRules);
        $resultCountryRules = $conn->query($CountryRules);

        $listMainRestriction = mysqli_fetch_all($resultMainRestriction, MYSQLI_ASSOC);
        $listresultIpRules = mysqli_fetch_all($resultIpRules, MYSQLI_ASSOC);
        $listresultCountryRules = mysqli_fetch_all($resultCountryRules, MYSQLI_ASSOC);
        $conn->close();
        $countOfMainRestiction = count($listMainRestriction);
        $countOfIP = count($listresultIpRules);
        $CountOfCountry = count($listresultCountryRules);

        $CountOfAllRecords = intVal($CountOfCountry) + intVal($countOfIP) + intVal($countOfMainRestiction);

        if ($CountOfAllRecords > $NewPlanCountOfRules) {
            return ["status" => "error", "message" => "تعداد قوانین فایروال شما بیش از حد مجاز پلان انتخاب شده است"];
        }
        if (intVal($CountOfCountry) > 0) {
            foreach ($listresultCountryRules as $c) {
                $websitename = $c["d_name"];
                if ($c["d_name"] != $c["ws_recordname"])
                    $websitename = $c["ws_recordname"] . "." . $c["d_name"];
                // return $c;
                $s = explode(",", $c["sfcm_country"]);
                if (count($s) > $NewPlanmaxIpInFirewall) {
                    return ["status" => "error", "message" => "تعداد کشور های درج شده در یک قانون بیش از حدمجاز پلان درخواستی شماست <br /> قوانین صفحات سایت :"
                        . $websitename . " مسیر فرعی " . $c["sf_name"]];
                }
            }
        }
        if (intVal($countOfIP) > 0) {
            foreach ($listresultIpRules as $c) {
                $websitename = $c["d_name"];
                if ($c["d_name"] != $c["ws_recordname"])
                    $websitename = $c["ws_recordname"] . "." . $c["d_name"];

                $s = explode(",", $c["sfim_ip"]);

                if (count($s) > $NewPlanmaxIpInFirewall) {
                    return ["status" => "error", "message" => "تعداد IP درج شده در یک قانون بیش از حدمجاز پلان درخواستی شماست <br /> قوانین صفحات سایت :"
                        . $websitename . " مسیر فرعی " . $c["sf_name"]];
                }
            }
        }
        if (intVal($countOfIP) > 0) {
            foreach ($listMainRestriction as $c) {
                // return $c;
                $websitename = $c["d_name"];
                if ($c["d_name"] != $c["ws_recordname"])
                    $websitename = $c["ws_recordname"] . "." . $c["d_name"];

                $s = explode("-", $c["mi_country"]);
                $d = explode("-", $c["mi_ip"]);

                if (count($s) + count($d) > $NewPlanmaxIpInFirewall) {
                    return ["status" => "error", "message" => "تعداد IP درج شده در یک قانون بیش از حدمجاز پلان درخواستی شماست <br /> قوانین صفحات سایت :"
                        . $websitename];
                }
            }
        }
        return ["status" => "success"];
    }
    public static function CheckPlan($token, $websiteID)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteID, $uid);
        if ($websitesOwner["status"] == "error") {

            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $planwebsite = $websitesOwner["data"][0]["d_plan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (isset($plans[$planwebsite]["ipvisitor"])) {
            } else {
                return [
                    "status" => "error", "action" => "needtoupgrade",
                    "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید ",
                    "plans" => CheckPlanRequest("ipvisitor")

                ];
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }
        return ["status" => "success"];
        // 902
    }
    public static function GetListOfRESTRICTION($token, $websiteID)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteID, $uid);
        if ($websitesOwner["status"] == "error") {

            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $sql = "SELECT miid as id, " . $GLOBALS['mi_country'] . " as  countries," . $GLOBALS['mi_ip'] . " as  ips ,mi_default as  def, mi_desc  " .
            " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
            . $GLOBALS['mi_websiteid'] . "=" . $websiteID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error",  "message" => "شما سرویس امنیتی برای این وب سایت فعال نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $dts = [];
            $i = 0;
            foreach ($list as $l) {
                $dts[$i]["id"] = $l["id"];
                $dts[$i]["default"] = $l["def"];
                $dts[$i]["ip"] = explode("-", $l["ips"]);
                $dts[$i]["countries"] = explode("-", $l["countries"]);
                $dts[$i]["desc"] = $l["mi_desc"];
                $i++;
            }
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $dts
            ];
        }

        $result->free_result();
        $conn->close();

        return $listOfRecordType;
    }
    public static function InternalGetListOfRESTRICTION($websiteID)
    {

        $sql = "SELECT miid as id, " . $GLOBALS['mi_country'] . " as  countries," . $GLOBALS['mi_ip'] . " as  ips ,mi_default as  def, mi_desc  " .
            " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
            . $GLOBALS['mi_websiteid'] . "=" . $websiteID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error",   "message" => "شما سرویس امنیتی برای این وب سایت فعال نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $dts = [];
            $i = 0;
            foreach ($list as $l) {
                $dts[$i]["id"] = $l["id"];
                $dts[$i]["default"] = $l["def"];
                $dts[$i]["ip"] = explode("-", $l["ips"]);
                $dts[$i]["countries"] = explode("-", $l["countries"]);
                $dts[$i]["desc"] = $l["mi_desc"];
                $i++;
            }
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $dts
            ];
        }

        $result->free_result();
        $conn->close();

        return $listOfRecordType;
    }
    public static function GetCountOfRules($websiteid)
    {
        $sql = "SELECT count(miid) as id" .
            " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
            . $GLOBALS['mi_websiteid'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            return 0;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            return $list[0]["id"];
        }
    }
    public static function RemoveRESTRICTION($token, $websiteID, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteID, $uid);
        if ($websitesOwner["status"] == "error") {

            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "DELETE FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE " . $GLOBALS['mi_websiteid'] . "=" . $websiteID . " AND miid=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        // $dmn = "";
        // if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
        //     $dmn = $websitesOwner["data"][0]["d_name"];
        // } else {
        //     $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        // }
        // if(self::GetCountOfRules($websiteID)==0)
        //     API_GEO_ADMIN::RunDisableAPIGEO($dmn,null);
        // else
        //     self::GenerateAndSendDataToAPI($websiteID,$uid);

        $defaultValues = $websitesOwner["data"][0]["ws_default_firewall"];
        $df = "no";
        if ($defaultValues == "allow") {
            $df = "yes";
        }

        self::GenerateAndSendDataToAPI($websiteID, $uid, $df);

        $listOfRecordType = ["status" => "success", "message" => "درخواست شما باموفقیت انجام شد"];

        $conn->close();

        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        if (self::GetCountOfRules($websiteID) == 0)
            API_GEO_ADMIN::RunDisableAPIGEO($dmn, null);
        else
            self::GenerateAndSendDataToAPI($websiteID, $uid, $df);

        return $listOfRecordType;
    }

    public static function CheckCountryIsDuplicated($websiteid, $Country, $id = 0)
    {
        if ($id == 0) {
            $sql = "SELECT miid as id, " . $GLOBALS['mi_country'] . " as  countries  " .
                " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
                . $GLOBALS['mi_websiteid'] . "=" . $websiteid;
        } else {
            $sql = "SELECT miid as id, " . $GLOBALS['mi_country'] . " as  countries " .
                " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
                . $GLOBALS['mi_websiteid'] . "=" . $websiteid . " AND miid!=" . $id;
        }

        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error",  "message" => "شما سرویس امنیتی برای این وب سایت فعال نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $dts = [];
            $i = 0;
            $ips = [];
            $countries = [];
            foreach ($list as $l) {
                $m = explode("-", $l["countries"]);
                foreach ($m as $n) {
                    array_push($ips, $n);
                }
                $h = explode("-", $l["countries"]);
                foreach ($h as $j) {
                    array_push($countries, $j);
                }
                $i++;
            }
        }

        $result->free_result();
        $conn->close();
        $a = "new";
        if (in_array($Country, $countries))
            $a = "duplicate";
        return  $a;
    }
    public static function CheckIPIsDuplicated($websiteid, $ip, $id = 0)
    {
        if ($id == 0) {
            $sql = "SELECT miid as id, " . $GLOBALS['mi_country'] . " as  countries," . $GLOBALS['mi_ip'] . " as  ips ,mi_default as  def, mi_desc  " .
                " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
                . $GLOBALS['mi_websiteid'] . "=" . $websiteid;
        } else {
            $sql = "SELECT miid as id, " . $GLOBALS['mi_country'] . " as  countries," . $GLOBALS['mi_ip'] . " as  ips ,mi_default as  def, mi_desc  " .
                " FROM " . $GLOBALS["mainrestriction_tablename"] . " WHERE "
                . $GLOBALS['mi_websiteid'] . "=" . $websiteid . " AND miid!=" . $id;
        }
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error",  "message" => "شما سرویس امنیتی برای این وب سایت فعال نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $dts = [];
            $i = 0;
            $ips = [];
            $countries = [];
            foreach ($list as $l) {
                $m = explode("-", $l["ips"]);
                foreach ($m as $n) {
                    array_push($ips, $n);
                }
                $h = explode("-", $l["countries"]);
                foreach ($h as $j) {
                    array_push($countries, $j);
                }
                $i++;
            }
        }

        $result->free_result();
        $conn->close();
        $a = "new";
        if (in_array($ip, $ips))
            $a = "duplicate";
        return $a;
    }
    public static function UserCanAccessToId($websiteid, $id)
    {
        $sql = "SELECT *,mi_ip as ips, mi_country as countries,mi_default as def FROM tbl_main_restriction where  	miid=" . $id . " AND mi_websiteid=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error",  "message" => "شناسه درخواستی نامعتبر است"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);

            $iplist = explode("-", $list[0]["ips"]);
            $countrylist = explode("-", $list[0]["countries"]);
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => [
                    "default" => $list[0]["def"],
                    "ip" => $iplist,
                    "countries" => $countrylist,
                    "desc" => $list[0]["mi_desc"]
                ]
            ];
        }

        $result->free_result();
        $conn->close();

        return $listOfRecordType;
    }
    public static function UpdateRestrictionDetails($token, $websiteid, $default, $ips, $countries, $desc, $action = "add", $id = "0")
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $defaultValues = $websitesOwner["data"][0]["ws_default_firewall"];
        $plans = ReturnPlans();
        $planwebsite = $websitesOwner["data"][0]["d_plan"];
        $countOfrulesInPlan = $plans[$planwebsite]["firewall"];
        if (self::GetCountOfRules($websiteid) >= $countOfrulesInPlan &&  $id=="0") {
            return ["status" => "error", "message" => "تعداد قوانین فایروال شما به پایان رسیده است و برای قوانین بیشتر باید پلان خود را ارتقا دهید"];
        }

        $country_array = [
            "AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
            "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
            "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
            "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
            "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
            "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
            "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
            "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
            "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
            "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
            "TV", "UG", "UA", "AE", "GB", "US", "UK", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
        ];

        $arraydefault_array = ["allow", "deny"];

        if (!in_array($default, $arraydefault_array)) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی"];
        }
        if ($countries != "") {
            $country = explode(",", $countries);
            $res = [];
            $stat = 1;
            foreach ($country as $cntr) {
                if ($action == "add") {
                    if (self::CheckCountryIsDuplicated($websiteid, $cntr) == "duplicate") {
                        return ["status" => "error", self::CheckCountryIsDuplicated($websiteid, $cntr), "message" => "کشور درخواستی شما تکراری است"];
                    }
                } else {
                    if (self::CheckCountryIsDuplicated($websiteid, $cntr, $id) == "duplicate") {
                        return ["status" => "error", self::CheckCountryIsDuplicated($websiteid, $cntr), "message" => "کشور درخواستی شما تکراری است"];
                    }
                }

                if (!in_array(strtoupper($cntr), $country_array)) {
                    $stat = 0;
                    array_push(
                        $res,
                        [
                            "status" => "error", "country" => $cntr,
                            "message" => "کشور  نامعتبر است"
                        ]
                    );
                }
            }
            if ($stat == 0) {
                return ["status" => "error", "countries" => $res];
            }
        }

        if ($ips != "") {
            $ipes = explode(",", $ips);
            $res = [];
            $stat = 1;
            if (count($ipes) >  $plans[$planwebsite]["maxipinfirewall"]  ) {
                return ["status" => "error",count($ipes),$plans[$planwebsite]["maxipinfirewall"], "message" => "تعداد IP مجاز  شما به پایان رسیده است و برای قوانین بیشتر باید پلان خود را ارتقا دهید"];
            }
            foreach ($ipes as $ip) {
                if (strpos($ip, '/')) {
                    $nip = explode("/", $ip);
                    if ($action == "add") {
                        if (self::CheckIPIsDuplicated($websiteid, $ip) == "duplicate") {
                            return ["status" => "error", "message" => "IP درخواستی شما تکراری است"];
                        }
                    } else {
                        if (self::CheckIPIsDuplicated($websiteid, $ip, $id) == "duplicate") {
                            return ["status" => "error", "message" => "IP درخواستی شما تکراری است"];
                        }
                    }
                    if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push(
                            $res,
                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                        );
                    }
                } else {
                    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push(
                            $res,
                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                        );
                    }
                    if ($action == "add") {
                        if (self::CheckIPIsDuplicated($websiteid, $ip) == "duplicate") {
                            return ["status" => "error", "message" => "IP درخواستی شما تکراری است"];
                        }
                    } else {
                        if (self::CheckIPIsDuplicated($websiteid, $ip, $id) == "duplicate") {
                            return ["status" => "error", "message" => "IP درخواستی شما تکراری است"];
                        }
                    }
                }
                if ($stat == 0) {
                    return ["status" => "error", "ips" => $res];
                }
            }
        }
        $outapi = "";
        $outip = str_replace(",", "-", $ips);
        $outcountry = str_replace(",", "-", $countries);
        if ($outcountry == "" && $outip == "") {
            return ["status" => "error", "message" => "مقایر IP و کشور به صورت همزان نمیتوانید خالی باشد"];
        }

        if ($outcountry == "") {
            $outapi = $outip;
        } else if ($outip == "") {
            $outapi = $outcountry;
        } else {
            $outapi = $outcountry . "-" . $outip;
        }
        if ($action == "add") {
            $ins = "INSERT INTO " . $GLOBALS["mainrestriction_tablename"] . " (" . $GLOBALS['mi_websiteid'] . "," . $GLOBALS['mi_country'] . "," . $GLOBALS['mi_ip'] . "," . $GLOBALS['mi_default'] . "," . $GLOBALS['mi_desc'] . ")
                VALUE (" . $websiteid . ",'" . $outcountry . "','" . $outip . "','" . $default . "','" . $desc . "')";
        } else if ($action == "update") {
            $uam = self::UserCanAccessToId($websiteid, $id);
            if ($uam["status"] == "error") {
                return $uam;
            }

            $ins = "UPDATE " . $GLOBALS["mainrestriction_tablename"] . " SET " . $GLOBALS['mi_country'] . "='" . $outcountry . "'," . $GLOBALS['mi_ip'] . "='" . $outip . "'," . $GLOBALS['mi_desc'] . "='" . $desc . "'," .
                $GLOBALS['mi_default'] . "='" . $default . "'
                        WHERE " . $GLOBALS['mi_websiteid'] . "=" . $websiteid . " AND miid=" . $id;
        }
        $conn = GetConnection();
        $conn->query($ins);
        if ($action == "add") {
            $id = $conn->insert_id;
        }
        $conn->close();
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        $df = "no";
        if ($defaultValues == "allow") {
            $df = "yes";
        }
        $outapi = self::GenerateAndSendDataToAPI($websiteid, $uid, $df);
        //   API_GEO_ADMIN::RunCreateAPIGEO($dmn,$df,$outapi,null);

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "id" => $id . ""];
    }
    public static function GenerateAndSendDataToAPI($websiteid, $uid, $df)
    {
        $AllData = self::InternalGetListOfRESTRICTION($websiteid);
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {

            return ["status" => "error", $websitesOwner, "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        if ($AllData["status"] == "error") {
            API_GEO_ADMIN::RunDisableAPIGEO($dmn, null);
            return;
        }
        $default = $AllData["data"][0]["default"];
        $allowedCountry = "";
        $BlockedCountry = "";
        $allowedip = "";
        $Blockedip = "";
        for ($i = 0; $i < count($AllData["data"]); $i++) {
            if ($AllData["data"][$i]["default"] == "allow") {
                if (count($AllData["data"][$i]["ip"]) > 0) {
                    $aip = implode("-", $AllData["data"][$i]["ip"]);
                }
                if (count($AllData["data"][$i]["countries"]) > 0) {
                    $acountry = implode("-", $AllData["data"][$i]["countries"]);
                }
                if ($i > 0) {
                    $allowedip .= "-" . $aip;
                    $allowedCountry .= "-" . $acountry;
                } else {
                    $allowedip .= $aip;
                    $allowedCountry .= $acountry;
                }
            }
            if ($AllData["data"][$i]["default"] == "deny") {
                if (count($AllData["data"][$i]["ip"]) > 0) {
                    $aip = implode("-", $AllData["data"][$i]["ip"]);
                }
                if (count($AllData["data"][$i]["countries"]) > 0) {
                    $acountry = implode("-", $AllData["data"][$i]["countries"]);
                }
                if ($i > 0) {
                    $BlockedCountry .= "-" . $acountry;
                    $Blockedip .= "-" . $aip;
                } else {
                    $BlockedCountry .= $acountry;
                    $Blockedip .= $aip;
                }
            }

            //   if($AllData["data"][$i]["default"]=="deny" && $AllData["data"][0]["default"]=="allow"){
            //     //  $default="deny";
            //      if(count($AllData["data"][$i]["ip"])>0){
            //          $aip=implode("-",$AllData["data"][$i]["ip"]);
            //      }
            //      if(count($AllData["data"][$i]["countries"])>0){
            //          $acountry=implode("-",$AllData["data"][$i]["countries"]);
            //      }
            //      if($i>0)
            //       $BlockedCountry.="-".$aip."-".$acountry;
            //      else
            //         $BlockedCountry.=$aip."-".$acountry;

            //   }
            //   if($AllData["data"][$i]["default"]=="allow" && $AllData["data"][0]["default"]=="allow"){
            //     //  $default="deny";
            //      if(count($AllData["data"][$i]["ip"])>0){
            //          $aip=implode("-",$AllData["data"][$i]["ip"]);
            //      }
            //      if(count($AllData["data"][$i]["countries"])>0){
            //          $acountry=implode("-",$AllData["data"][$i]["countries"]);
            //      }
            //       if($i>0)
            //       $allowedCountry.="-".$aip."-".$acountry;
            //      else
            //       $allowedCountry.=$aip."-".$acountry;
            //   }

        }
        $allowedCountry = str_replace("--", "-", $allowedCountry);
        $BlockedCountry = str_replace("--", "-", $BlockedCountry);
        if (substr($allowedCountry, -1) == "-")
            $allowedCountry = substr($allowedCountry, 0, strlen($allowedCountry) - 1);
        if (substr($allowedCountry, 0, 1) == "-")
            $allowedCountry = substr($allowedCountry, 1, strlen($allowedCountry));

        if (substr($BlockedCountry, -1) == "-")
            $BlockedCountry = substr($BlockedCountry, 0, strlen($BlockedCountry) - 1);
        if (substr($BlockedCountry, 0, 1) == "-")
            $BlockedCountry = substr($BlockedCountry, 1, strlen($BlockedCountry));

        $allowedip = str_replace("--", "-", $allowedip);
        $Blockedip = str_replace("--", "-", $Blockedip);
        if (substr($allowedip, -1) == "-")
            $allowedip = substr($allowedip, 0, strlen($allowedip) - 1);
        if (substr($allowedip, 0, 1) == "-")
            $allowedip = substr($allowedip, 1, strlen($allowedip));

        if (substr($Blockedip, -1) == "-")
            $Blockedip = substr($Blockedip, 0, strlen($Blockedip) - 1);
        if (substr($Blockedip, 0, 1) == "-")
            $Blockedip = substr($Blockedip, 1, strlen($Blockedip));

        $r = API_GEO_ADMIN::RunCreateAPIGEO($dmn, $df, $BlockedCountry, null, true, "0", $BlockedCountry, $allowedCountry, $Blockedip, $allowedip);
        return ["BlockedCountry" => $BlockedCountry, "allowedCountry" => $allowedCountry, "Blockedip" => $Blockedip, "allowedip" => $allowedip, "default" => $df, "resp" => $r]; //  $AllData["data"]

    }

    public static function AddRestrictionDetails($token, $websiteid, $default, $ips, $countries, $desc, $action = "add", $id = "0")
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $country_array = [
            "AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
            "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
            "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
            "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
            "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
            "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
            "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
            "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
            "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
            "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
            "TV", "UG", "UA", "AE", "GB", "US", "UK", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
        ];

        $arraydefault_array = ["allow", "deny"];

        if (!in_array($default, $arraydefault_array)) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی"];
        }
        if ($countries != "") {
            $country = explode(",", $countries);
            $res = [];
            $stat = 1;
            foreach ($country as $cntr) {

                if (self::CheckCountryIsDuplicated($websiteid, $cntr) == "duplicate") {
                    return ["status" => "error", "کشور درخواستی شما تکراری است"];
                }
                if (!in_array(strtoupper($cntr), $country_array)) {

                    $stat = 0;
                    array_push(
                        $res,
                        [
                            "status" => "error", "country" => $cntr,
                            "message" => "کشور  نامعتبر است"
                        ]
                    );
                }
            }
            if ($stat == 0) {
                return ["status" => "error", "countries" => $res];
            }
        }

        if ($ips != "") {
            $ipes = explode(",", $ips);
            $res = [];
            $stat = 1;

            foreach ($ipes as $ip) {
                if (strpos($ip, '/')) {
                    $nip = explode("/", $ip);
                    if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push(
                            $res,
                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                        );
                    }
                    if (self::CheckIPIsDuplicated($websiteid, $nip[0]) == "duplicate") {
                        return ["status" => "error", "IP درخواستی شما تکراری است"];
                    }
                } else {
                    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push(
                            $res,
                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                        );
                    }
                    if (self::CheckIPIsDuplicated($websiteid, $ip) == "duplicate") {
                        return ["status" => "error", "IP درخواستی شما تکراری است"];
                    }
                }
                if ($stat == 0) {
                    return ["status" => "error", "ips" => $res];
                }
            }
        }
        $outapi = "";
        $outip = str_replace(",", "-", $ips);
        $outcountry = str_replace(",", "-", $countries);
        if ($outcountry == "" && $outip == "") {
            return ["status" => "error", "message" => "مقایر IP و کشور به صورت همزان نمیتوانید خالی باشد"];
        }

        if ($outcountry == "") {
            $outapi = $outip;
        } else if ($outip == "") {
            $outapi = $outcountry;
        } else {
            $outapi = $outcountry . "-" . $outip;
        }
        // if($action=="add"){
        //      $ins = "INSERT INTO " . $GLOBALS["mainrestriction_tablename"] . " (" . $GLOBALS['mi_websiteid'] . "," . $GLOBALS['mi_country'] . "," . $GLOBALS['mi_ip'] . "," . $GLOBALS['mi_default'] . "," . $GLOBALS['mi_desc'] . ")
        //         VALUE (" . $websiteid . ",'" . $outcountry . "','" . $outip . "','" . $default . "','".$desc."')";
        // }
        // else{
        //     if($action=="update"){

        $sql = "SELECT * FROM " . $GLOBALS["mainrestriction_tablename"] .
            " WHERE " . $GLOBALS["mi_websiteid"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["mainrestriction_tablename"] . " (" . $GLOBALS['mi_websiteid'] . "," . $GLOBALS['mi_country'] . "," . $GLOBALS['mi_ip'] . "," . $GLOBALS['mi_default'] . "," . $GLOBALS['mi_desc'] . ")
                VALUE (" . $websiteid . ",'" . $outcountry . "','" . $outip . "','" . $default . "','" . $desc . "')";
        } else {
            $ins = "UPDATE " . $GLOBALS["mainrestriction_tablename"] . " SET " . $GLOBALS['mi_country'] . "='" . $outcountry . "'," . $GLOBALS['mi_ip'] . "='" . $outip . "'," . $GLOBALS['mi_desc'] . "='" . $desc . "'," .
                $GLOBALS['mi_default'] . "='" . $default . "'
                        WHERE " . $GLOBALS['mi_websiteid'] . "=" . $websiteid;
        }
        //  $conn->close();
        //     }
        // }
        //   $conn = GetConnection();
        $conn->query($ins);
        $conn->close();
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        $df = "no";
        if ($default == "allow") {
            $df = "yes";
        }
        // API_GEO_ADMIN::RunCreateAPIGEO($dmn,$df,$outapi,null);

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RunToSendForAPI($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["mainrestriction_tablename"] .
            " WHERE " . $GLOBALS["mi_websiteid"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        $outapi = "";
        $outip = "";
        $outcountry = "";
        foreach ($list as $l) {
            $outapi .= "-" . $l["mi_ip"];
            $outcountry = "-" . $l["mi_country"];
        }

        $outapi = "";
        if ($outcountry == "") {
            $outapi = $outip;
        } else if ($outip == "") {
            $outapi = $outcountry;
        } else {
            $outapi = $outcountry . "-" . $outip;
        }

        $df = "no";
        // if ($default == "allow") {
        //     $df = "yes";
        // }

        API_GEO_ADMIN::RunCreateAPIGEO($dmn, $df, $outapi, null);
    }
}
