<?php
require_once '../../../include/vars.php';
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

require_once $GLOBALS["RootFiles"] . '/apitobackend/headertoclient/headertoclient.php';

class HEADERTOCLIENT_ADMIN
{

    public static function GetWebsiteHeaderToClient($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $sql = "SELECT htc_name as HeaderName,htc_value as HeaderValue,htc_id as HeaderID FROM " . $GLOBALS["headertoclient_tablename"] .
            " WHERE " . $GLOBALS["htc_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [ $sql, "status" => "success", "message" => "اطلاعاتی جهت نمایش وجود ندارد" ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $r
            ];
            $conn->close();
        }
        return $listOfRecordType;
    }

    public static function UpdateWebsiteHeaderToClient($token, $websiteid, $headername, $headervalue)
    {
        $reservedHeader_array = [
            "server", "mc-cache", "mc-cache-status", "country", "request-Country",
            "request-IP", "mc-id", "mc-eid"
        ];
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $name = strtolower($headername);
        $name = TOOLS_ADMIN::seo_friendly_url($name);
        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        if (in_array($headername, $reservedHeader_array)) {
            return ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["headertoclient_tablename"] .
            " WHERE " . $GLOBALS["htc_name"] . "='" . $headername . "' AND " . $GLOBALS["htc_wid_fk"] . "='" . $websiteid . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["headertoclient_tablename"] . " (" . $GLOBALS['htc_name'] . "," . $GLOBALS['htc_value'] . "," . $GLOBALS['htc_wid_fk'] . ")
                            VALUE ('" . $headername . "','" . $headervalue . "','" . $websiteid . "')";
        } else {
            API_HEADERTOCLIENT_ADMIN::RunDisableAPIHEADERTOCLIENT($dmn, $headername,"null");
            $ins = "UPDATE " . $GLOBALS["headertoclient_tablename"] . " SET " . $GLOBALS['htc_value'] . "='" . $headervalue . "'
                                    WHERE " . $GLOBALS['htc_name'] . "='" . $headername . "' AND " . $GLOBALS['htc_wid_fk'] . "='" . $websiteid . "'";
        }
        $conn->query($ins);
        $conn->close();
        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        API_HEADERTOCLIENT_ADMIN::RunCreateAPIHEADERTOCLIENT($dmn,$headername,$headervalue,"null");
        return [$ins, "status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveHeaderToClient($token, $websiteid, $headerid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["headertoclient_tablename"] .
            " WHERE " . $GLOBALS["htc_id"] . "=" . $headerid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $conn->close();
        } else {
            $res=mysqli_fetch_all($result,MYSQLI_ASSOC);
            $sql = "DELETE  FROM " . $GLOBALS["headertoclient_tablename"] .
                " WHERE " . $GLOBALS["htc_id"] . "=" . $res[0]["htc_id"];
            $result = $conn->query($sql);
            $conn->close();
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_HEADERTOCLIENT_ADMIN::RunDisableAPIHEADERTOCLIENT($dmn, $res[0]["htc_name"],"null");
        }
        return $listOfRecordType;
    }
}
