<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class HEADERTOBACKEND_ADMIN
{

    public static function GetWebsiteHeaderToBackend($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $sql = "SELECT htb_name as HeaderName,htb_value as HeaderValue,htb_id as HeaderID FROM " . $GLOBALS["headertobackend_tablename"] .
            " WHERE " . $GLOBALS["htb_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعاتی جهت نمایش وجود ندارد"
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $r
            ];
            $conn->close();
        }
        return $listOfRecordType;
    }

    public static function UpdateWebsiteHeaderToBackend($token, $websiteid, $headername, $headervalue)
    {
        $reservedHeader_array =
            ["host", "x-real-ip", "x-forwarded-for"];

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $name = strtolower($headername);
        $name = TOOLS_ADMIN::seo_friendly_url($name);
        $value = TOOLS_ADMIN::seo_friendly_url($headervalue);
        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        if (in_array($headername, $reservedHeader_array)) {
            $out = ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
        } else {
            $sql = "SELECT * FROM " . $GLOBALS["headertobackend_tablename"] .
                " WHERE " . $GLOBALS["htb_name"] . "='" . $headername . "' AND " . $GLOBALS["htb_wid_fk"] . "='" . $websiteid . "'";
            $conn = GetConnection();
            $result = $conn->query($sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $ins = "INSERT INTO " . $GLOBALS["headertobackend_tablename"] . " (" . $GLOBALS['htb_name'] . "," . $GLOBALS['htb_value'] . "," . $GLOBALS['htb_wid_fk'] . ")
                                VALUE ('" . $name . "','" . $value . "','" . $websiteid . "')";
            } else {
                API_HEADERTOBACKEND_ADMIN::RunDisableAPIHEADERTOBACKEND($dmn, $headername,"null");
                $ins = "UPDATE " . $GLOBALS["headertobackend_tablename"] . " SET " . $GLOBALS['htb_value'] . "='" . $value . "'
                                        WHERE " . $GLOBALS['htb_name'] . "='" . $name . "' AND " . $GLOBALS['htb_wid_fk'] . "='" . $websiteid . "'";
            }
            $conn->query($ins);
            $conn->close();
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_HEADERTOBACKEND_ADMIN::RunCreateAPIHEADERTOBACKEND($dmn,$headername,$headervalue,"null");
            return     ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        }
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveHeaderToBackend($token, $websiteid, $headerid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["headertobackend_tablename"] .
            " WHERE " . $GLOBALS["htb_id"] . "=" . $headerid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $conn->close();
        } else {
            $res=mysqli_fetch_all($result,MYSQLI_ASSOC);
            $sql = "DELETE  FROM " . $GLOBALS["headertobackend_tablename"] .
                " WHERE " . $GLOBALS["htb_id"] . "=" . $res[0]["htb_id"];
            $result = $conn->query($sql);
            $conn->close();
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_HEADERTOBACKEND_ADMIN::RunDisableAPIHEADERTOBACKEND($dmn, $res[0]["htb_name"],"null");
        }
        return $listOfRecordType;
    }
}
