<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class API_CLOUD_SERVER_ADMIN
{

    public static function GetServerDetailFromAPI($name, $idc, $sid)
    {
        $actionUrl = "api/v1/server/get";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $sid;



        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut);


        return    $api;
    }

    public static function  RunCreateServer($name, $image_id, $email, $idcid, $flavor_id, $key_id, $networks, $security_groups, $vid)
    {

        $actionUrl = "api/v1/server/create";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["name"] = $name;
        $postededata["display_name"] = $name;
        $postededata["description"] = $name;
        $postededata["image_id"] = $image_id;
        $postededata["flavor_id"] = $flavor_id;
        $postededata["networks"] = $networks;
        $postededata["security_groups"] = $security_groups;
        $postededata["key_id"] = $key_id;
        $postededata["block_device_mapping"] = $vid;


        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $api = json_decode($apiOut);


        return    $api;
    }
    public static function  RunExtendAPIVolume($id, $email, $idcid, $size)
    {

        $actionUrl = "api/v1/volume/extend";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $id;
        $postededata["size"] = $size;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $m = json_decode($apiOut);
        //$id= $m->id;
        return    $apiOut;
    }
    public static function RunAttachFirewallToServer($name, $serverid, $firewallid, $idc)
    {
        $actionUrl = "api/v1/server/add_security_group";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $serverid;
        $postededata["security_group"] = $firewallid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunDetachFirewallToServer($name, $serverid, $firewallid, $idc)
    {
        $actionUrl = "api/v1/server/remove_security_group";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $serverid;
        $postededata["security_group"] = $firewallid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunAttachVolumeToServer($name, $serverid, $vlid, $idc)
    {
        $actionUrl = "api/v1/server/volume/create";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $serverid;
        $postededata["volume_id"] = $vlid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunDetachVolumeToServer($name, $serverid, $vlid, $idc)
    {
        $actionUrl = "api/v1/server/volume/delete";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["server_id"] = $serverid;
        $postededata["volume_id"] = $vlid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunHardReboot($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/hardreboot";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunPauseServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/pause_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunRebuildOS($mail, $serverid, $imageid, $idc)
    {
        $actionUrl = "api/v1/server/rebuild_new_image";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server_id"] = $serverid;
        $postededata["image_id"] = $imageid;
        $postededata["is_snapshot"] = "False";
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return     $apiOut;
    }
    public static function  RunRestoreSnapshot($mail, $serverid, $imageid, $idc)
    {
        $actionUrl = "api/v1/server/rebuild_new_image";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server_id"] = $serverid;
        $postededata["image_id"] = $imageid;
        $postededata["is_snapshot"] = "True";
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    [$postededata, $apiOut, $idc];
    }

    public static function  RunChangeHostname($id, $mail, $idc, $hostname)
    {
        $actionUrl = "api/v1/server/update_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $postededata["name"] = $hostname;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunStartServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/start_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunResizeServer($id, $mail, $idc, $flavordid)
    {
        $actionUrl = "api/v1/server/resize_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $postededata["flavor"] = $flavordid;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        self::ConfirmResize($id, $mail, $idc);

        return    $apiOut;
    }
    public static function ConfirmResize($id, $mail, $idc)
    {
        $actionUrl = "/api/v1/server/confirm_resize";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
    }
    public static function  RunShutDownServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/stop_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunUnPauseServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/unpause_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunSoftReboot($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/softreboot";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunChangePassword($id, $mail, $idc, $password)
    {
        $actionUrl = "api/v1/server/changepassword";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $postededata["password"] = $password;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  GetInterfaceList($mail, $idc, $sid)
    {
        $actionUrl =  "api/v1/server/interface/list";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }

    public static function  RunAttachPublicNetworkNetwork($mail, $idc, $sid)
    {
        $actionUrl = "api/v1/server/interface/attach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["subnet_id"] = SENDAPI_MIDDLECLOUD::GetMiddleAPIInfo($idc)[1]["ci_public_network"];
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }

    public static function  RunAttachInternalNetwork($mail, $idc, $sid, $networkid)
    {
        $actionUrl = "api/v1/server/interface/attach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["subnet_id"] = $networkid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunDetachPublicNetwork($mail, $idc, $sid, $networkid)
    {
        $actionUrl = "api/v1/server/interface/detach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["port_id"] = $networkid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunDetachInternalNetwork($mail, $idc, $sid, $networkid)
    {
        $actionUrl = "api/v1/server/interface/detach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["port_id"] = $networkid;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function  RunGetVNCConsole($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/get_vnc_console";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut);
        return    $api->url;
    }
    public static function  RunRemoveVolume($id, $email, $idcid)
    {
        $actionUrl = "api/v1/volume/delete";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return    $apiOut;
    }
    public static function  RunDeleteServer($id, $email, $idcid)
    {
        $actionUrl = "api/v1/server/force_delete";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return    $apiOut;
    }
}
