<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class API_CLOUD_FIREWALLRULES_ADMIN
{

    public static function  RunCreateAPIFIREWALLRULES(
        $direction,
        $description,
        $email,
        $idcid,
        $port_range_min,
        $port_range_max,
        $ethertype,
        $remote_ip_prefix,
        $security_group_id,
        $protocol,
        $project_id
    ) {

        $actionUrl = "api/v1/securitygroup/rule/create";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["direction"] = $direction;

        $postededata["port_range_min"] = $port_range_min;
        $postededata["port_range_max"] = $port_range_max;

        $postededata["description"] = $description;
        $postededata["ethertype"] = $ethertype;
        $postededata["remote_ip_prefix"] = $remote_ip_prefix;
        $postededata["protocol"] = $protocol;
        $postededata["security_group_id"] = $security_group_id;
        $postededata["project_id"] = $project_id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return   [$apiOut,$postededata];
    }
    public static function  RunDeleteSecurityGroupRule($email, $ruleid, $idcid)
    {

        $actionUrl = "api/v1/securitygroup/rule/delete";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $ruleid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return  [$postededata, $apiOut];
    }
    public static function  RunGetSecurityGroupRules($email, $fwid, $idcid)
    {
        $actionUrl = "api/v1/securitygroup/rules";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $fwid;


        return SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
    }
    public static function  RunDeleteDomainCDN($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "dns_delete";
        $postededata["domain"] = $domain;

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
}
