( function ( $ ) {
	'use strict';

	var orOdiScript = {
		id: 'or-OdiScript',
		name: 'ଓଡ଼ିସ୍କ୍ରିପ୍ଟ',
		description: 'Odia OdiScript input method',
		date: '2015-7-28',
		URL: 'http://github.com/wikimedia/jquery.ime',
		author: 'Manoj Sahukar and Subhashish Panigrahi',
		license: 'GPLv3',
		version: '1.0',
		contextLength: 6,
		maxKeyLength: 4,
		patterns: [
			[ '/([A-Za-z\\>_\\-\\!@#\\$\\^\\&\\%\\*\\~\\.\\|\\\\0-9])', '$1' ],
			[ '\'([\'])','\"' ], // '' to "
			[ '\"([\'])','\'\'\'' ], // '''
			[ '([କ-ହ]୍[କ-ହ])@@', 'ର୍\$1' ], // reph
			[ '([କ-ହ])@@', 'ର୍\$1' ], // reph
			[ '%%', 'ଙ୍କ' ], // Anka
			[ '"', 'ଁ' ], // chanda bindu
			[ '([ର])}', 'ର‍୍ୟ' ], // special case: Ja phala (ର + ZWJ + ୍ୟ)
			[ '\\}', '୍ୟ' ], // Ja phala
			[ '୍\ ', '୍‌ ' ], // ending with halant+zwnj
			[ '{', 'ୃ' ], // Ru kara
			[ 'େk', 'ୋ' ], //  l= ekar, lk = okar
			[ 'ାl', 'ୋ' ], //  l= ekar, kl = okar
			[ 'େp', 'ୈ' ], //
			[ 'ୈk', 'ୌ' ], //
			[ '\\]', '୍ର' ], // Ra phala
			[ '\\[', 'ଅ' ], // Type ଅ
			[ 'ଅk','ଆ' ], // ଅ + ା = ଆ
			[ 'ଓ##','ୱ' ],
			[ '([ର])##', 'ର‍୍ୱ' ], // special case ର + ZWJ + ୍ୱ
			[ '([କ-ହ])##', '$1୍ୱ' ], //
			[ 'ଦQ', 'ହ' ],
			[ '([କନପସମ])Q', 'ତ୍\$1' ],
			[ '([ଖଥଧ])Q', '$1ି' ],
			[ '([ନସ])_', '$1୍ତ୍ର' ], // ନ୍ତ୍ର , ସ୍ତ୍ର
			[ '\\$', 'କ୍ଷ' ],
			[ '\\&&','ଏବଂ' ],
			[ '\\^', 'ଋ' ],
			[ '\\|', 'ଞ' ],
			[ '\\\\', 'ୟ' ],
			[ '<', 'ଏ' ],
			[ '>', 'ଐ' ],
			[ '0', '୦' ],
			[ '1', '୧' ],
			[ '2', '୨' ],
			[ '3', '୩' ],
			[ '4', '୪' ],
			[ '5', '୫' ],
			[ '6', '୬' ],
			[ '7', '୭' ],
			[ '8', '୮' ],
			[ '9', '୯' ],
			[ 'a', 'ମ' ],
			[ 'A', 'ଢ଼' ],
			[ 'b', 'ୁ' ],
			[ 'B', 'ଉ' ],
			[ 'c', 'ଜ' ],
			[ 'C', 'ଝ' ],
			[ 'd', '୍' ],
			[ 'D', '‌' ], // zwnj
			[ 'e', 'ନ' ],
			[ 'E', 'ଡ଼' ],
			[ 'f', 'ତ' ],
			[ 'F', 'ଥ' ],
			[ 'G', 'ଇ' ],
			[ 'g', 'ି' ],
			[ 'H', 'ଈ' ],
			[ 'h', 'ୀ' ],
			[ 'i', 'ଂ' ],
			[ 'I', 'ଠ' ],
			[ 'j', 'ର' ],
			[ 'J', 'ଣ' ],
			[ 'k', 'ା' ],
			[ 'K', 'ଶ' ],
			[ 'l', 'େ' ],
			[ 'L', 'ଷ' ],
			[ 'm', 'ଳ' ],
			[ 'M', 'ଲ' ],
			[ 'n', 'ୂ' ],
			[ 'N', 'ଊ' ],
			[ 'o', 'ହ' ],
			[ 'O', 'ଡ' ],
			[ 'p', 'ୈ' ],
			[ 'P', 'ଢ' ],
			[ 'q', 'ବ' ],
			[ 'r', 'ଦ' ],
			[ 'R', 'ଧ' ],
			[ 's', 'କ' ],
			[ 'S', 'ଖ' ],
			[ 't', 'ସ' ],
			[ 'T', 'ଓ' ],
			[ 'u', 'ଯ' ],
			[ 'U', 'ଟ' ],
			[ 'v', 'ଚ' ],
			[ 'V', 'ଛ' ],
			[ 'w', 'ପ' ],
			[ 'W', 'ଫ' ],
			[ 'x', 'ଗ' ],
			[ 'X', 'ଘ' ],
			[ 'y', 'ୌ' ],
			[ 'Y', 'ଔ' ],
			[ 'z', 'ଭ' ],
			[ 'Z', 'ଙ' ],
			[ '`', '।' ],
			[ '~', 'ଃ' ]
		]
	};

	$.ime.register( orOdiScript );
}( jQuery ) );
