( function ( $ ) {
	'use strict';

	var neTrad = {
		id: 'ne-trad',
		name: 'Nepali Traditional',
		description: 'Nepali Traditional keyboard layout',
		date: '2013-02-12',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			[ '\"', 'ू' ],
			[ '\\#', 'घ' ],
			[ '\'', 'ु' ],
			[ '\\(', 'ढ' ],
			[ '\\)', 'ण' ],
			[ '\\+', 'ं' ],
			[ ',', 'ऽ' ],
			[ '\\-', 'औ' ],
			[ '\\.', '।' ],
			[ '/', 'र' ],
			[ '0', '०' ],
			[ '1', '१' ],
			[ '2', '२' ],
			[ '3', '३' ],
			[ '4', '४' ],
			[ '5', '५' ],
			[ '6', '६' ],
			[ '7', '७' ],
			[ '8', '८' ],
			[ '9', '९' ],
			[ ';', 'स' ],
			[ '\\<', 'ङ' ],
			[ '\\=', '=' ],
			[ '\\?', 'रु' ],
			[ '\\@', 'ई' ],
			[ 'A', 'आ' ],
			[ 'B', 'ौ' ],
			[ 'C', 'ऋ' ],
			[ 'E', 'ऐ' ],
			[ 'F', 'ँ' ],
			[ 'H', 'झ' ],
			[ 'J', 'ो' ],
			[ 'K', 'फ' ],
			[ 'L', 'ी' ],
			[ 'O', 'इ' ],
			[ 'P', 'ए' ],
			[ 'U', 'ऊ' ],
			[ 'V', 'ॐ' ],
			[ '\\\\', '्' ],
			[ '\\]', 'े' ],
			[ '\\_', 'ओ' ],
			[ '`', 'ञ' ],
			[ 'a', 'ब' ],
			[ 'b', 'द' ],
			[ 'c', 'अ' ],
			[ 'd', 'म' ],
			[ 'e', 'भ' ],
			[ 'f', 'ा' ],
			[ 'g', 'न' ],
			[ 'h', 'ज' ],
			[ 'i', 'ष' ],
			[ 'j', 'व' ],
			[ 'k', 'प' ],
			[ 'l', 'ि' ],
			[ 'm', 'ः' ],
			[ 'n', 'ल' ],
			[ 'o', 'य' ],
			[ 'p', 'उ' ],
			[ 'r', 'च' ],
			[ 's', 'क' ],
			[ 't', 'त' ],
			[ 'u', 'ग' ],
			[ 'v', 'ख' ],
			[ 'w', 'ध' ],
			[ 'x', 'ह' ],
			[ 'y', 'थ' ],
			[ 'z', 'श' ],
			[ '\\{', 'ृ' ],
			[ '\\|', '|' ],
			[ '\\}', 'ै' ],
			[ '\\~', '॥' ],
			[ '\\!', 'ज्ञ' ],
			[ '\\$', 'द्ध' ],
			[ ':', 'ट्ठ' ],
			[ '\\>', 'श्र' ],
			[ 'D', 'ङ्ग' ],
			[ 'G', 'द्द' ],
			[ 'I', 'क्ष' ],
			[ 'M', 'ड्ड' ],
			[ 'N', 'द्य' ],
			[ 'Q', 'त्त' ],
			[ 'R', 'द्ब' ],
			[ 'S', 'ङ्क' ],
			[ 'T', 'ट्ट' ],
			[ 'W', 'ड्ढ' ],
			[ 'X', 'ह्य' ],
			[ 'Y', 'ठ्ठ' ],
			[ 'Z', 'क्क' ],
			[ '\\[', 'र्' ],
			[ 'q', 'त्र' ] ]
	};

	$.ime.register( neTrad );
}( jQuery ) );
