<?php if ( $wallets ): ?>
    <div class="uk-grid uk-grid-medium uk-grid-match ums-wallet-box" uk-grid>
        <div class=" uk-width-3-3@l uk-width-3-3@xl">
            <div class="uk-overflow-auto">
                <table class="uk-table uk-table-hover uk-table-divider uk-table-middle uk-table-responsive">
                    <thead>
                    <tr>
                        <th class="uk-table-shrink"></th>
                        <th><?php _e( 'Charge amount', 'wp_ums' ) ?></th>
                        <th><?php _e( 'Price', 'wp_ums' ) ?></th>
                        <th><?php _e( 'Charging gift', 'wp_ums' ) ?></th>
                        <th><?php _e( 'Buy', 'wp_ums' ) ?></th>
                    </tr>
                    </thead>
                    <tbody>
					<?php foreach ( $wallets as $wallet ): ?>
                        <tr>
                            <td><img style="width: 49px"
                                     src="<?php echo UMS_ASSETS . 'img/wallet_image.webp' ?>"
                                     alt="Alt text"
                                     class="uk-border-circle uk-preserve-width "></td>
                            <td style="text-align: center"><?php echo \classes\UMS_Utility::show_amount( number_format( $wallet['amount_wallet'] ) ); ?>
                            </td>
                            <td style="text-align: center"><?php echo \classes\UMS_Utility::show_amount( number_format( $wallet['amount_wallet'] ) ) ?></td>
                            <td style="text-align: center"><?php echo \classes\UMS_Utility::show_amount( number_format( $wallet['amount_gift_wallet'] ) ); ?></td>
                            <td style="text-align: center"><a class="btn-order-wallet"
                                                              href="<?php echo home_url( ums_get_slug_user_panel() . '/ums-checkout/wallet-' . $wallet['code_wallet'] ) ?>"><?php _e( 'Charge', 'wp_ums' ) ?></a>
                            </td>
                        </tr>
					<?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php endif; ?>

