<div class="uk-overflow-auto">
    <table class="uk-table uk-table-hover uk-table-middle uk-table-divider">
		<?php
		$pagenum = isset( $_GET['pagenum'] ) ? absint( $_GET['pagenum'] ) : 1;
		global $post;
        $post_type_name = ! empty( \classes\Admin\UMS_Setting_API::get( 'post-type-submissions-post' ) ) ? \classes\Admin\UMS_Setting_API::get( 'post-type-submissions-post' ) : 'post';
		$options = array(
			'post_type'      => $post_type_name,
			'paged'          => $pagenum,
			'posts_per_page' => 10,
			'post_status'    => 'any',
			'author'         => $users->ID
		);
		$query   = new WP_Query( $options );
		$limit   = 5;
		if ( $query->have_posts() ): ?>
        <thead>
        <tr>
            <th class="uk-table-shrink"><?php _e( 'featuring image', 'wp_ums' ) ?></th>
            <th class="uk-table-shrink"><?php _e( 'Title', 'wp_ums' ) ?></th>
            <th class="uk-table-shrink "><?php _e( 'Release date', 'wp_ums' ) ?></th>
            <th class="uk-table-shrink"><?php _e( 'Status', 'wp_ums' ) ?></th>
            <th class="uk-table-shrink"><?php _e( 'processes', 'wp_ums' ) ?></th>
        </tr>
        </thead>
        <tbody>

		<?php while ( $query->have_posts() ) :
			$query->the_post();
			$thumbnail = '';
			if ( has_post_thumbnail() ) {
				$thumbnail = get_the_post_thumbnail_url( get_the_ID() );
			}
			?>
            <tr>
                <td style="text-align: center"><img class="uk-preserve-width uk-border-circle"
                                                    src="<?php 
                                                    if($thumbnail){
                                                        echo $thumbnail;
                                                    }else{
                                                        $url = UMS_ASSETS . 'img/no-image.jpg';
                                                        echo $url;        
                                                    }
                                                     ?>"
                                                    width="40" height="40" alt=""></td>
                <td style="text-align: center" class="uk-table-link">
					<?php echo the_title(); ?>
                </td>
                <td style="text-align: center"
                    class="uk-table-link"><?php echo get_the_date(); ?></td>
                <td style="text-align: center" class="uk-text-nowrap">
					<?php if ( get_post_status( $post->ID ) == 'publish' ): ?>
                        <span style="    background: #0fda0f;
    padding:5px 13px;
    border-radius: 5px;
    color: #fff;"><?php _e( 'publish', 'wp_ums' ) ?></span>
					<?php elseif ( get_post_status( $post->ID ) == 'draft' ): ?>
                        <span style="    background: #f1bf30;
    padding: 5px 13px;
    border-radius: 5px;
    color: #fff;"><?php _e( 'draft', 'wp_ums' ) ?></span>
					<?php elseif ( get_post_status( $post->ID ) == 'pending' ): ?>
                        <span style="    background: #f1bf30;
    padding: 5px 13px;
    border-radius: 5px;
    color: #fff;"><?php _e( 'pending', 'wp_ums' ) ?></span>
					<?php endif; ?>
                </td>
                <td style="text-align: center" class="uk-text-nowrap">
                    <a class="uk-link-reset" title="<?php _e( 'View content', 'wp_ums' ) ?>"
                       href="<?php echo the_permalink(); ?>"><span
                                uk-icon="link"></span></a>
					<?php
					$edit_post = get_post_meta($post->ID, 'ums_edit_active_post', true);
					?>
					<?php if ( $edit_post == 'yes' && \classes\Admin\UMS_Setting_API::get( 'enable-edit-submissions-post' ) ): ?>
                        <a class="uk-link-reset" title="<?php _e( 'Edit content', 'wp_ums' ) ?>"
                           href="<?php echo esc_url( add_query_arg( 'post_id', $post->ID, esc_url( home_url( ums_get_slug_user_panel() . '/edit-post' ) ) ) ); ?>"><span
                                    uk-icon="pencil"></span></a>
					<?php endif; ?>
                    <?php if ( \classes\Admin\UMS_Setting_API::get( 'enable-delete-submissions-post' ) ): ?>
                        <a class="uk-link-reset" title="<?php _e( 'Delete content', 'wp_ums' ) ?>"
                           href="<?php echo esc_url_raw( wp_nonce_url(add_query_arg( ['action'=>'delete','post_id'=>$post->ID] ),'ums_delete_post')); ?>"><span
                                    uk-icon="trash"></span></a>
                    <?php endif; ?>
                </td>
            </tr>
		<?php endwhile; ?>
		<?php
		$page_links = paginate_links( array(
			'base'      => add_query_arg( 'pagenum', '%#%' ),
			'format'    => '',
			'prev_text' => __( '&laquo;', 'text-domain' ),
			'next_text' => __( '&raquo;', 'text-domain' ),
			'total'     => $query->max_num_pages,
			'current'   => $pagenum
		) );
		if ( $page_links ) {
			echo '<div class="page-numbers-ums-list-post" style="width: 99%;"><div class="tablenav-pages" style="margin: 1em 0;text-align: center">' . $page_links . '</div></div>';
		}
		wp_reset_postdata(); ?>
		<?php else: ?>
            <p style="color: #95aad2;
    text-align: center;
    width: 100%;
    font-size: 14px;
    margin-top: 45px;"><?php _e( 'Content not sent by you', 'wp_ums' ) ?></p>
		<?php endif; ?>
        </tbody>
    </table>
</div>

