<?php

if (! defined('ABSPATH')) {
	exit;
}

$downloads     = WC()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;
if ( $has_downloads ) {
	$ums_downloads = array();
	foreach ( $downloads as $ums_download ) {
		$ums_downloads[ $ums_download['product_id'] ][ $ums_download['order_id'] ][] = $ums_download;
	}
}
?>
<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see    https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


do_action( 'woocommerce_before_account_downloads', $has_downloads ); ?>

<?php if ( $has_downloads ) : ?>

	<?php do_action( 'woocommerce_before_available_downloads' ); ?>

    <div class="ums-download-accordion">
		<?php foreach ( $ums_downloads as $product_id => $orders_download ): ?>
			<?php $img_url = get_the_post_thumbnail( $product_id, 'thumbnail' ); ?>
            <div class="ums-download-accordion-item">
                <div class="ums-download-accordion-header">
                    <div class="ums-download-accordion-title">
						<?php echo $img_url; ?>
                        <div class="ums-download-accordion-title-circle"></div>
                        <span><?php echo esc_html(get_the_title( $product_id )); ?></span>
                    </div>
                    <span class="ums-download-accordion-toggle">+</span>
                </div>
                <div class="ums-download-accordion-content">
					<?php foreach ( $orders_download as $order_id => $download_items ): ?>
						<?php if ( ! empty( $download_items ) ): ?>
                            <p style="font-size: 13px;font-weight: 700;color: #000;padding-right: 25px;padding-top: 15px;">
								<?php echo esc_html__( 'Order number : ', 'wp_ums' ) . $order_id ?></p>
                            <table class="uk-table  uk-table-divider">
                                <thead id="title-list-download">
                                <tr>
                                    <th><?php esc_html_e( 'File', 'woocommerce' ); ?></th>
                                    <th><?php esc_html_e( 'Downloads remaining', 'woocommerce' ); ?></th>
                                    <th><?php esc_html_e( 'Expires', 'woocommerce' ); ?></th>
                                </tr>
                                </thead>
                                <tbody>
								<?php foreach ( $download_items as $key => $ums_download ): ?>
                                    <tr>
                                        <td data-label="<?php esc_html_e( 'File', 'woocommerce' ); ?>" style="text-align: center;    width: 25%;" id="link-download">
                                            <a href="<?php echo esc_url( $ums_download['download_url'] ); ?>">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19"
                                                     viewBox="0 0 20 19">
                                                    <g id="Iconly_Bulk_Download" data-name="Iconly/Bulk/Download"
                                                       transform="translate(-2 -2.5)">
                                                        <g id="Download" transform="translate(2 2.5)">
                                                            <path id="Fill-1"
                                                                  d="M2.9,6.344A4.526,4.526,0,0,1,7.49,1.9h5.032A4.515,4.515,0,0,1,17.1,6.334V17.45a4.526,4.526,0,0,1-4.59,4.448H7.479A4.517,4.517,0,0,1,2.9,17.46V6.344Z"
                                                                  transform="translate(21.898 1.898) rotate(90)"
                                                                  fill="#49be78" opacity="0.4"/>
                                                            <path id="Fill-4"
                                                                  d="M16.654,6.338,13.686,3.429a.79.79,0,0,0-1.106,0,.762.762,0,0,0,0,1.089l1.625,1.593H3.9a.77.77,0,1,0,0,1.54H14.207L12.582,9.247a.762.762,0,0,0,0,1.089.79.79,0,0,0,1.106,0l2.968-2.909a.761.761,0,0,0,0-1.091"
                                                                  transform="translate(16.885 -3.117) rotate(90)"
                                                                  fill="#49be78"/>
                                                        </g>
                                                    </g>
                                                </svg>
												<?php echo esc_html($ums_download['file']['name']) ?>
                                            </a>
                                        </td>
                                        <td data-label="<?php esc_html_e( 'Downloads remaining', 'woocommerce' ); ?>" style="text-align: center;    width: 25%;"><?php echo is_numeric( $ums_download['downloads_remaining'] ) ? esc_html( $ums_download['downloads_remaining'] ) : esc_html__( '&infin;', 'woocommerce' ); ?></td>
                                        <td data-label="<?php esc_html_e( 'Expires', 'woocommerce' ); ?>" style="text-align: center;    width: 25%;">
											<?php if ( ! empty( $ums_download['access_expires'] ) ) : ?>
                                                <time datetime="<?php echo esc_attr(date( 'Y-m-d', strtotime( $ums_download['access_expires'] ) )); ?>"
                                                      title="<?php echo esc_attr( strtotime( $ums_download['access_expires'] ) ); ?>"><?php echo esc_html(date_i18n( get_option( 'date_format' ), strtotime( $ums_download['access_expires'] ) )); ?></time>
											<?php else : ?>
												<?php esc_html_e( 'Never', 'woocommerce' ); ?>
											<?php endif; ?>
                                        </td>
                                    </tr>
								<?php endforeach; ?>
                                </tbody>
                            </table>
						<?php endif; ?>
					<?php endforeach; ?>
                </div>

            </div>
		<?php endforeach; ?>
    </div>
	<?php do_action( 'woocommerce_after_available_downloads' ); ?>

<?php else : ?>
    <div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
        <a class="woocommerce-Button button"
           href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php esc_html_e( 'Go shop', 'woocommerce' ); ?>
        </a>
		<?php esc_html_e( 'No downloads available yet.', 'woocommerce' ); ?>
    </div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_account_downloads', $has_downloads ); ?>
