<?php
if (! defined('ABSPATH')) {
    exit;
}
?>
<div class="form-group smu-admin-select">
    <label class="form-check-label" id="page-login" for=""><?php esc_html_e('Login and register page', 'wp_ums'); ?></label>
    <select id="page-login" class="umss-form-control" name="page-login">
        <option value='0'><?php esc_html_e('Select the page', 'wp_ums') ?></option>
        <?php $pages = get_pages(); ?>
        <?php foreach ($pages as $page) { ?>
            <option value='<?php echo esc_attr($page->ID); ?>' <?php selected($options::get('page-login'), $page->ID); ?>><?php echo esc_attr($page->post_title); ?></option>
        <?php }; ?>
    </select>
    <p><?php esc_html_e('Shortcode Login and Registration Form : [ums-login-form]', 'wp_ums') ?></p>
</div>

<div class="form-group smu-admin-select">
    <label class="form-check-label" id="login-type" for=""><?php esc_html_e('How to enter the site', 'wp_ums'); ?></label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="login-form-mobile"
        name="login-form-mobile" <?php echo checked($options::get('login-form-mobile'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="login-form-mobile">
        <span><?php esc_html_e('Mobile Number', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="login-form-email"
        name="login-form-email" <?php echo checked($options::get('login-form-email'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="login-form-email">
        <span><?php esc_html_e('Email', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="login-form-username"
        name="login-form-username" <?php echo checked($options::get('login-form-username'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="login-form-username">
        <span><?php esc_html_e('Username', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="login-form-password"
        name="login-form-password" <?php echo checked($options::get('login-form-password'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="login-form-password">
        <span><?php esc_html_e('Password', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-two-factor-authentication-login"
        name="enable-two-factor-authentication-login" <?php echo checked($options::get('enable-two-factor-authentication-login'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-two-factor-authentication-login">
        <?php esc_html_e('Two-factor authentication', 'wp_ums') ?>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-login-otp-code"
        name="enable-login-otp-code" <?php echo checked($options::get('enable-login-otp-code'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-login-otp-code">
        <span><?php esc_html_e('Login with one-time password', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-select">
    <label class="form-check-label" id="login-type"
        for=""><?php esc_html_e('Specify a username template', 'wp_ums'); ?></label>
    <select id="specify-username-template" class="umss-form-control" name="specify-username-template">
        <option value='mobile-number' <?php selected($options::get('specify-username-template'), 'mobile-number'); ?>><?php echo esc_html_e('Use mobile number', 'wp_ums'); ?></option>
        <option value='custom-expressions' <?php selected($options::get('specify-username-template'), 'custom-expressions'); ?>><?php echo esc_html_e('Custom expressions + user ID', 'wp_ums'); ?></option>
        <option value='random-numbers' <?php selected($options::get('specify-username-template'), 'random-numbers'); ?>><?php echo esc_html_e('Random numbers', 'wp_ums'); ?></option>
    </select>
</div>
<div class="form-group smu-admin-input-text custom-expressions-wrapper">
    <label class="form-check-label" id="specify-username-template-custom-expressions"
        for=""><?php esc_html_e('Custom expressions', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder=""
        name="specify-username-template-custom-expressions"
        value="<?php echo esc_attr($options::get('specify-username-template-custom-expressions')) ?>">
</div>
<div class="form-group smu-admin-input-text random-numbers-wrapper">
    <label class="form-check-label" id="length-username-template-random-numbers" for="">
        <?php esc_html_e('Determining the length of username numbers', 'wp_ums'); ?>
    </label>
    <input type="text" class="umss-form-control" id="" placeholder="" name="length-username-template-random-numbers"
        value="<?php echo esc_attr($options::get('length-username-template-random-numbers')) ?>">
</div>

<div class="form-group smu-admin-select">
    <label class="form-check-label" id="remember-me"
        for=""><?php esc_html_e('Remember me', 'wp_ums'); ?></label>
    <select id="remember-me" class="umss-form-control" name="remember-me">
        <option value='always-active' <?php selected($options::get('remember-me'), 'always-active'); ?>><?php echo esc_html_e('Always active', 'wp_ums'); ?></option>
        <option value='active-user' <?php selected($options::get('remember-me'), 'active-user'); ?>><?php echo esc_html_e('Active with user selection', 'wp_ums'); ?></option>
        <option value='inactive' <?php selected($options::get('remember-me'), 'inactive'); ?>><?php echo esc_html_e('Inactive', 'wp_ums'); ?></option>
    </select>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="disable-icon-show-password"
        name="disable-icon-show-password" <?php echo checked($options::get('disable-icon-show-password'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="disable-icon-show-password">
        <span><?php esc_html_e('Disable password display icon', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="restriction-view-full-site"
        name="restriction-view-full-site" <?php echo checked($options::get('restriction-view-full-site'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="restriction-view-full-site">
        <span><?php esc_html_e('Restrict the entire site to login', 'wp_ums') ?></span>
    </label>
</div>

<div id="restriction-view-full-site-excluded">
    <div class="form-group smu-admin-input-textarea">
        <label for="restriction-view-full-site-excluded"><?php esc_html_e('Excluded Pages from Login Restriction', 'wp_ums'); ?></label>
        <textarea row="6" type="text" class="umss-form-control" id="restriction-view-full-site-excluded" placeholder=""
            name="restriction-view-full-site-excluded"><?php echo esc_textarea($options::get('restriction-view-full-site-excluded')); ?></textarea>
        <p><?php esc_html_e('Pages or URLs entered here will remain accessible without login. The login restriction will not apply to them (one address per line)', 'wp_ums') ?></p>
    </div>
</div>

<p class="smu-section-title"><?php esc_html_e('Pop-up Login and Register', 'wp_ums') ?></p>
<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-popup-login-register"
        name="enable-popup-login-register" <?php echo checked($options::get('enable-popup-login-register'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-popup-login-register">
        <span><?php esc_html_e('Activate the login and register pop-up', 'wp_ums') ?></span>
    </label>
</div>
<div class="ums-wrapper-popup-setting">
    <div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
        <input class="umss-checkbox" id="enable-popup-register-form"
            name="enable-popup-register-form" <?php echo checked($options::get('enable-popup-register-form'), 'yes'); ?>
            type="checkbox" value="yes">
        <label class="form-check-label" for="enable-popup-register-form">
            <span><?php esc_html_e('Activate the pop-up register form', 'wp_ums') ?></span>
        </label>
    </div>

    <div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
        <input class="umss-checkbox" id="enable-popup-login-form"
            name="enable-popup-login-form" <?php echo checked($options::get('enable-popup-login-form'), 'yes'); ?>
            type="checkbox" value="yes">
        <label class="form-check-label" for="enable-popup-login-form">
            <span><?php esc_html_e('Activate the pop-up login form', 'wp_ums') ?></span>
        </label>
    </div>
</div>

<p class="smu-section-title"><?php esc_html_e('Automatic email creation', 'wp_ums') ?></p>
<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-email-creation-after-register"
        name="enable-email-creation-after-register" <?php echo checked($options::get('enable-email-creation-after-register'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-email-creation-after-register">
        <span><?php esc_html_e('Enable email creation', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-select">
    <label class="form-check-label" id="email-prefix-after-register"
        for=""><?php esc_html_e('Email prefix', 'wp_ums'); ?></label>
    <select id="remember-me" class="umss-form-control" name="email-prefix-after-register">
        <option value='username' <?php selected($options::get('email-prefix-after-register'), 'username'); ?>><?php echo esc_html_e('Username', 'wp_ums'); ?></option>
        <option value='mobile' <?php selected($options::get('email-prefix-after-register'), 'mobile'); ?>><?php echo esc_html_e('Mobile Number', 'wp_ums'); ?></option>
    </select>
</div>

<div class="form-group smu-admin-input-text">
    <label class="form-check-label" id="email-extension-after-register"
        for=""><?php esc_html_e('Email extension', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder="" name="email-extension-after-register"
        value="<?php echo esc_attr($options::get('email-extension-after-register')) ?>">
</div>



<p class="smu-section-title"><?php esc_html_e('Create automatic display name', 'wp_ums') ?></p>
<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-display-name-creation-after-register"
        name="enable-display-name-creation-after-register" <?php echo checked($options::get('enable-display-name-creation-after-register'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-display-name-creation-after-register">
        <span><?php esc_html_e('Enable display name creation', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-select">
    <label class="form-check-label" id="display-name-pattern-after-register"
        for=""><?php esc_html_e('Set display name pattern', 'wp_ums'); ?></label>
    <select id="remember-me" class="umss-form-control" name="display-name-pattern-after-register">
        <option value='random-numbers' <?php selected($options::get('display-name-pattern-after-register'), 'random-numbers'); ?>><?php echo esc_html_e('Custom expressions + Random numbers', 'wp_ums'); ?></option>
        <option value='custom-expressions' <?php selected($options::get('display-name-pattern-after-register'), 'custom-expressions'); ?>><?php echo esc_html_e('Custom expressions', 'wp_ums'); ?></option>
    </select>
</div>

<div class="form-group smu-admin-input-text">
    <label class="form-check-label" id="custom-expressions-display-name-after-register"
        for=""><?php esc_html_e('Custom expressions', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder="" name="custom-expressions-display-name-after-register"
        value="<?php echo esc_attr($options::get('custom-expressions-display-name-after-register')) ?>">
</div>


<div class="form-group smu-admin-input-text">
    <label class="form-check-label" id="redirect-after-login"
        for=""><?php esc_html_e('Redirect link after login', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder="" name="redirect-after-login"
        value="<?php echo esc_attr($options::get('redirect-after-login')) ?>">
</div>

<div class="form-group smu-admin-input-text">
    <label class="form-check-label" id="redirect-after-register"
        for=""><?php esc_html_e('Redirect link after register', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder="" name="redirect-after-register"
        value="<?php echo esc_attr($options::get('redirect-after-register')) ?>">
</div>

<div class="form-group smu-admin-input-text">
    <label class="form-check-label" id="redirect-after-logout"
        for=""><?php esc_html_e('Redirect link after logout', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder="" name="redirect-after-logout"
        value="<?php echo esc_attr($options::get('redirect-after-logout')) ?>">
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-automatic-login-after-registration"
        name="enable-automatic-login-after-registration" <?php echo checked($options::get('enable-automatic-login-after-registration'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-automatic-login-after-registration">
        <?php esc_html_e('Automatic login after registration', 'wp_ums') ?>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-redirect-wp-admin"
        name="enable-redirect-wp-admin" <?php echo checked($options::get('enable-redirect-wp-admin'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-redirect-wp-admin">
        <span><?php esc_html_e('Redirect the default WordPress login page to the Vira login page', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-password-strong"
        name="enable-password-strong" <?php echo checked($options::get('enable-password-strong'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-password-strong">
        <span><?php esc_html_e('Strong password activation', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-checkout-edd-lock-guest-users"
        name="enable-checkout-edd-lock-guest-users" <?php echo checked($options::get('enable-checkout-edd-lock-guest-users'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-checkout-edd-lock-guest-users">
        <span><?php esc_html_e('Lock edd payment page for guest users', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text">
    <label class="form-check-label" id="password-length" for=""><?php esc_html_e('Password length', 'wp_ums'); ?></label>
    <input type="text" class="umss-form-control" id="" placeholder="8" name="password-length"
        value="<?php echo esc_attr($options::get('password-length')) ?>">
</div>

<p class="smu-section-title"><?php esc_html_e('Password recovery', 'wp_ums') ?></p>
<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-password-forgetting"
        name="enable-password-forgetting" <?php echo checked($options::get('enable-password-forgetting'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-password-forgetting">
        <span><?php esc_html_e('Activate password forgetting', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-password-forgetting-email"
        name="enable-password-forgetting-email" <?php echo checked($options::get('enable-password-forgetting-email'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-password-forgetting-email">
        <span><?php esc_html_e('Forget password via email', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-password-forgetting-mobile"
        name="enable-password-forgetting-mobile" <?php echo checked($options::get('enable-password-forgetting-mobile'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-password-forgetting-mobile">
        <span><?php esc_html_e('Forget mobile password', 'wp_ums') ?></span>
    </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-automatic-login-after-reset-password"
        name="enable-automatic-login-after-reset-password" <?php echo checked($options::get('enable-automatic-login-after-reset-password'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-automatic-login-after-reset-password">
        <span><?php esc_html_e('Automatic login after changing the password', 'wp_ums') ?></span>
    </label>
</div>

<p class="smu-section-title"><?php esc_html_e('International mobile number template', 'wp_ums') ?></p>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
    <input class="umss-checkbox" id="enable-send-international-sms"
        name="enable-send-international-sms" <?php echo checked($options::get('enable-send-international-sms'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-send-international-sms">
        <?php esc_html_e('International mobile number template', 'wp_ums') ?>
    </label>
</div>

<dv class="ums-wrapper-international-template">
    <div class="form-group smu-admin-select">
        <label class="form-check-label" for=""><?php esc_html_e('Default country prefix', 'wp_ums'); ?></label>
        <select class="umss-form-control country_code_settings" id="default_country_code" name="default_country_code">
            <option value="-1"><?php esc_html_e('Inactive', 'wp_ums') ?></option>
            <?php foreach (ums_get_country_list() as $meta_key => $value) : ?>
                <option value="<?php echo esc_attr($meta_key) ?>" <?php echo ($options::get('default_country_code') == $meta_key) ? 'selected' : ''; ?>><?php echo esc_html($value['name'] . ' (+' . $value['phone'] . ')') ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="form-group smu-admin-select">
        <label class="form-check-label" for=""><?php esc_html_e('List of allowed country codes', 'wp_ums'); ?></label>
        <select class="umss-form-control country_code_settings" id="allowed_country_codes"
            name="allowed_country_codes[]" multiple>
            <?php foreach (ums_get_country_list() as $meta_key => $value) : ?>
                <option value="<?php echo esc_attr($meta_key) ?>" <?php echo (is_array($options::get('allowed_country_codes')) && in_array($meta_key, $options::get('allowed_country_codes'))) ? 'selected' : ''; ?>><?php echo esc_html($value['name'] . ' (+' . $value['phone'] . ')') ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="form-group smu-admin-select">
        <label class="form-check-label" for=""><?php esc_html_e('List of illegal country codes', 'wp_ums'); ?></label>
        <select class="umss-form-control country_code_settings" id="illegal_country_codes"
            name="illegal_country_codes[]" multiple>
            <?php foreach (ums_get_country_list() as $meta_key => $value) : ?>
                <option value="<?php echo esc_attr($meta_key) ?>" <?php echo (is_array($options::get('illegal_country_codes')) && in_array($meta_key, $options::get('illegal_country_codes'))) ? 'selected' : ''; ?>><?php echo esc_html($value['name'] . ' (+' . $value['phone'] . ')') ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
        <input class="umss-checkbox" id="disable-dial-code-separated"
            name="disable-dial-code-separated" <?php echo checked($options::get('disable-dial-code-separated'), 'yes'); ?>
            type="checkbox" value="yes">
        <label class="form-check-label" for="disable-dial-code-separated">
            <?php esc_html_e('Disable country code display', 'wp_ums') ?>
        </label>
    </div>

    <div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
        <input class="umss-checkbox" id="enable-automatic-country-code-ip"
            name="enable-automatic-country-code-ip" <?php echo checked($options::get('enable-automatic-country-code-ip'), 'yes'); ?>
            type="checkbox" value="yes">
        <label class="form-check-label" for="enable-automatic-country-code-ip">
            <?php esc_html_e('Automatic detection of country code based on IP', 'wp_ums') ?>
        </label>
    </div>
</dv>

<div class="form-group smu-admin-input-text umss-checkbox">
    <input class="umss-checkbox" id="enable-terms-conditions-register"
        name="enable-terms-conditions-register" <?php echo checked($options::get('enable-terms-conditions-register'), 'yes'); ?>
        type="checkbox" value="yes">
    <label class="form-check-label" for="enable-terms-conditions-register">
        <?php esc_html_e('Activate Terms and Conditions', 'wp_ums') ?>
    </label>
</div>

<div class="form-group smu-admin-select page-terms-conditions">
    <label class="form-check-label" for=""><?php esc_html_e('Page Terms and Conditions', 'wp_ums'); ?></label>
    <select class="umss-form-control" name="page-terms-conditions">
        <?php $pages = get_pages(); ?>
        <?php foreach ($pages as $page) { ?>
            <option value='<?php echo esc_attr($page->ID); ?>' <?php selected($options::get('page-terms-conditions'), $page->ID); ?>>
                <?php echo esc_html($page->post_title); ?></option>
        <?php }; ?>
    </select>
</div>

<div class="form-group smu-admin-input-text">
    <label style="display: block;"
        for=""><?php esc_html_e('The image on the user information print page', 'wp_ums'); ?></label>
    <input style="width: 80%;" type="text" name="header-image-print-background"
        id="image-url-header-image-print-background" class="umss-form-control"
        value="<?php echo esc_html($options::get('header-image-print-background')); ?>">
    <input style="height: 48px;" type="button" name="upload-btn" id="save_header_image_print_background"
        class="btn-header-image-print-background btn-upload" value="<?php esc_html_e('Upload File', 'wp_ums') ?>">
    <p><?php esc_html_e('Image size: 1000 * 248', 'wp_ums') ?></p>
</div>

<div class="form-group smu-admin-input-text">
    <label style="display: block;"
        for=""><?php esc_html_e('Footer image of user information print page', 'wp_ums'); ?></label>
    <input style="width: 80%;" type="text" name="footer-image-print-background"
        id="image-url-footer-image-print-background" class="umss-form-control"
        value="<?php echo esc_html($options::get('footer-image-print-background')); ?>">
    <input style="height: 48px;" type="button" name="upload-btn" id="save_footer_image_print_background"
        class="btn-footer-image-print-background btn-upload" value="<?php esc_html_e('Upload File', 'wp_ums') ?>">
    <p><?php esc_html_e('Image size: 1000 * 248', 'wp_ums') ?></p>
</div>