<?php

namespace classes;

use classes\Admin\UMS_Setting_API;

if (! defined('ABSPATH')) {
	exit;
}
class UMS_Sms_Notification
{
	private $wpdb;
	public function __construct()
	{
		global $wpdb;
		$this->wpdb = $wpdb;
	}

	public function send($mobile_user, $message = null, $code_pattern = null, $otp = false)
	{

		$service    = UMS_Setting_API::get('notification-sms-provider');
		$class_name = 'UMS_' . ucfirst($service);
		$class      = '\classes\\Sms\\' . $class_name;
		if (! $service) {
			return null;
		}
		if (! $mobile_user) {
			return;
		}

		$message = ! is_null($code_pattern) ? $code_pattern : $message;

		return (new $class($mobile_user, $message, $otp))->send();
	}

	public function ums_sms_providers()
	{
		$providers = [
			'mediana'         => [
				'title' => 'mediana',
			],
			'activepayamak'   => [
				'title' => 'activepayamak',
			],
			'sarangsms'       => [
				'title' => 'sarangsms',
			],
			'farazsms'        => [
				'title' => 'farazsms',
			],
			'iranpayamak'        => [
				'title' => 'iranpayamak',
			],
			'ippanel'         => [
				'title' => 'ippanel',
			],
			'ippanelnew'         => [
				'title' => 'ippanel(New)',
			],
			'payamito'        => [
				'title' => 'payamito',
			],
			'payamresan'      => [
				'title' => 'payamresan',
			],
			'melipayamak'     => [
				'title' => 'melipayamak',
			],
			'modirpayamak'    => [
				'title' => 'modirpayamak',
			],
			'0098sms'         => [
				'title' => '0098sms',
			],
			'kavenegar'       => [
				'title' => 'kavenegar',
			],
			'smsir'           => [
				'title' => 'sms.ir',
			],
			'smsnewir'        => [
				'title' => 'sms.ir (New)',
			],
			'signalads'     => [
				'title' => 'سیگنال',
			],
			'farapayamak'     => [
				'title' => 'farapayamak',
			],
			'maxsms'          => [
				'title' => 'maxsms',
			],
			'mashhadhost'     => [
				'title' => 'mashhadhost',
			],
			'parsgreen'       => [
				'title' => 'parsgreen',
			],
			'payamresan'      => [
				'title' => 'payamresan',
			],
			'smsrata'         => [
				'title' => 'smsrata.ir',
			],
			'lamerdsms'       => [
				'title' => 'lamerdsms',
			],
			'smsmeli'         => [
				'title' => 'smsmeli',
			],
			'parandsms'       => [
				'title' => 'parandsms',
			],
			'idehpayam'       => [
				'title' => 'idehpayam',
			],
			'aradpayamak'     => [
				'title' => 'aradpayamak',
			],
			'negareshpayamak' => [
				'title' => 'negareshpayamak',
			],
			'raygansms'       => [
				'title' => 'raygansms',
			],
			'itpardaz'        => [
				'title' => 'itpardaz',
			],
			'rahyabsms'       => [
				'title' => 'rahyabsms',
			],
			'mediapayamak'    => [
				'title' => 'mediapayamak',
			],
			'saharsms'        => [
				'title' => 'saharsms',
			],
			'smssabanovin'    => [
				'title' => 'smssabanovin',
			],
			'panelsms20'      => [
				'title' => 'panelsms20',
			],
			'niksms'          => [
				'title' => 'niksms',
			],
			'popupsms'        => [
				'title' => 'popupsms',
			],
			'niazpardaz'      => [
				'title' => 'niazpardaz',
			],
			'yekpayamak'      => [
				'title' => 'yekpayamak',
			],
			'asanak'          => [
				'title' => 'asanak',
			],
			'arashpayamak'    => [
				'title' => 'arashpayamak',
			],
			'amnyar'          => [
				'title' => 'amnyar',
			],
			'ardinsms'        => [
				'title' => 'ardinsms',
			],
			'vatansms'        => [
				'title' => 'vatansms.com',
			],
			'twilio'          => [
				'title' => 'twilio.com',
			],
			'elanak'          => [
				'title' => 'elanak.ir',
			],
			'amootsms'        => [
				'title' => 'amootsms.com',
			],
			'1000sms'         => [
				'title' => '1000sms.ir',
			],
			'mihansms'        => [
				'title' => 'mihansms.com',
			],
			'mizbansms'       => [
				'title' => 'mizbansms.ir',
			],
			'webone'          => [
				'title' => 'webone-sms.ir',
			],
			'payamsms'        => [
				'title' => 'payamsms.com',
			],
			'sunwaysms'       => [
				'title' => 'sunwaysms.com',
			],
			'limosms'       => [
				'title' => 'limosms.com',
			],
			'isms'       => [
				'title' => 'isms.ir',
			],
		];

		return apply_filters('ums_sms_providers', $providers);
	}
}
