<?php

namespace classes\Sms;

use classes\UMS_Sms;
use SoapFault;

defined('ABSPATH') || exit('No Access!');

class UMS_Kavenegar extends UMS_Sms
{

	public function send()
	{
		ini_set("soap.wsdl_cache_enabled", "0");
		$input_data = [];
		if (is_array($this->message)) {
			$pattern_message = $this->message;
			$pattern_code    = $pattern_message['code_pattern'];
			if (count($pattern_message)) {
				foreach ($pattern_message as $key => $value) {
					if ($key == 'code_pattern') {
						continue;
					}
					$input_data[$key] = $value;
				}
			}
			$this->verify_lookup($this->to, $pattern_code, $input_data);
		} else {
			try {
				$messages = urlencode($this->message);
				$url      = "https://api.kavenegar.com/v1/$this->username/sms/send.json?sender=$this->from&receptor=$this->to&message=$messages";
				$ch       = curl_init($url);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				$sms_response = curl_exec($ch);
				curl_close($ch);
			} catch (SoapFault $ex) {
				wp_send_json($ex->faultstring);
			}
		}
	}

	private function verify_lookup($receptor, $template, $tokens = [])
	{
		$params = array(
			"receptor" => $receptor,
			"template" => $template,
		);
		$normalIndex = 0; 
		$spaceIndex  = 0; 
		foreach ($tokens as $value) {
			if (empty(trim($value))) {
				continue; 
			}

			if (strpos($value, ' ') !== false) {
				$spaceIndex++;
				$params["token{$spaceIndex}0"] = $value; 
			} else {
				$normalIndex++;
				if ($normalIndex == 1) {
					$params["token"] = $value;
				} else {
					$params["token{$normalIndex}"] = $value;
				}
			}
		}

		$fields_string = "";

		if (!is_null($params)) {
			$fields_string = http_build_query($params);
		}
		
		$send_lookup = "https://api.kavenegar.com/v1/" . $this->username . "/verify/lookup.json?" . $fields_string;
		wp_remote_get($send_lookup);
	}
}
