(function ($) {

    var Dokan_Vendor_Registration = {

        init: function () {
            var form = $('#ums-register-form');

            $('.ums-dokan-role input[type=radio]', form).on('change', this.showSellerForm);
            $('#shop-phone', form).on('keydown', this.ensurePhoneNumber);

            $('#seller-url', form).on('keydown', this.constrainSlug);
            $('#seller-url', form).on('keyup', this.renderUrl);
            $('#seller-url', form).on('focusout', this.checkSlugAvailability);

        },


        showSellerForm: function () {
            var value = $(this).val();
            console.log(value)
            if (value === 'seller') {
                $('.show_if_seller').find('input, select').removeAttr('disabled');
                $('.show_if_seller').slideDown();

            } else {
                $('.show_if_seller').find('input, select').attr('disabled', 'disabled');
                $('.show_if_seller').slideUp();
            }
        },
        constrainSlug: function (e) {
            var text = $(this).val();

            // Allow: backspace, delete, tab, escape, enter and .
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 91, 109, 110, 173, 189, 190]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right
                (e.keyCode >= 35 && e.keyCode <= 39)) {
                // let it happen, don't do anything
                return;
            }

            if ((e.shiftKey || (e.keyCode < 65 || e.keyCode > 90) && (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        },

        checkSlugAvailability: function () {
            var self = $(this),
                data = {
                    action: 'ums_register_form_shop_url',
                    url_slug: self.val(),
                    _nonce: dokan.nonce,
                };

            if (self.val() === '') {
                return;
            }

            var row = self.closest('.ums-dokan-seller-url');
            row.block({
                message: null,
                overlayCSS: {background: '#fff url(' + dokan.ajax_loader + ') no-repeat center', opacity: 0.6}
            });

            $.post(dokan.ajaxurl, data, function (resp) {
                if (resp.result === true) {
                    $('.ums-dokan-seller-url #url-alart-mgs').addClass('text-success');
                    $('.ums-dokan-seller-url #url-alart-mgs').text(dokan.seller.available);
                } else {
                    $('.ums-dokan-seller-url #url-alart-mgs').addClass('text-danger');
                    $('.ums-dokan-seller-url #url-alart-mgs').text(dokan.seller.notAvailable);
                }

                row.unblock();

            });
        },

        renderUrl: function () {
            $('#url-alart').text($(this).val());
        },

    };

// boot the class onReady
    $(function () {
        Dokan_Vendor_Registration.init();

        $('.show_if_seller').find('input, select').attr('disabled', 'disabled');

        // trigger change if there is an error while registering
        var shouldTrigger = $('.woocommerce ul').hasClass('woocommerce-error') && !$('.show_if_seller').is(':hidden');

        if (shouldTrigger) {
            var form = $('form.register');

            $('.user-role input[type=radio]', form).trigger('change');
        }
    });

})(jQuery);
