<?php

defined( 'ABSPATH' ) || exit;

class UMS_Autoloader
{

    public static function autoload_ums($className)
    {
        $prefix = 'classes\\';

        $len = strlen($prefix);
        if (0 !== strncmp($prefix, $className, $len)) {
            return;
        }

        $relative_class = substr($className, $len);

        $path = explode('\\', strtolower(str_replace('-', '-', $relative_class)));

        $file = array_pop($path);
        $file = str_replace('_', '-', $file);
        if(in_array('admin',$path) || in_array('admin\wizard',$path) || in_array('gateway',$path) || in_array('module',$path)|| in_array('module',$path) || in_array('frontend',$path) || in_array('form',$path)|| in_array('form\Settings',$path) || in_array('sms',$path) || in_array('widgets',$path) || in_array('restapi',$path) ){
            $path = ucfirst(implode('/', $path));
        }else{
            $path = implode('/', $path);
        }
        $file = UMS_DIR .'classes/'. ucwords($path,'/') . '/class-' . $file . '.php';
        if (file_exists($file)) {
	        require $file;
        }

    }

}
