<?php
	defined( 'ABSPATH' ) || exit;
?>

<div id="mfn-dashboard" class="mfn-ui mfn-dashboard" data-page="tools">

	<input type="hidden" name="mfn-builder-nonce" value="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>">

	<?php
		// header
		include_once get_theme_file_path('/functions/admin/templates/parts/header.php');
	?>

	<div class="mfn-wrapper">

		<?php
			// subheader
			$current = 'tools';
			include_once get_theme_file_path('/functions/admin/templates/parts/subheader.php');
		?>

		<div class="mfn-dashboard-wrapper">
			<div class="mfn-row">

				<div class="row-column row-column-4">

					<div class="mfn-card mfn-shadow-1" data-card="tool-item">
						<div class="card-content">
							<div class="tool-logo">
								<span class="local-css">لوکال <b>CSS</b>
								</span>
							</div>
							<p>بازتولید استایلهای CSS در فایلها و دیتابیس</p>
							<a data-nonce="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>" data-action="mfn_regenerate_css" class="mfn-btn mfn-btn-fw tools-do-ajax" href="#">
								<span class="btn-wrapper"><?php esc_html_e( 'Regenerate files', 'mfn-opts' ); ?></span>
							</a>
						</div>
					</div>

				</div>

				<div class="row-column row-column-4">

					<div class="mfn-card mfn-shadow-1" data-card="tool-item">
						<div class="card-content">
							<div class="tool-logo">
								<span class="local-fonts">لوکال <b>Fonts</b>
								</span>
							</div>
							<p>کش فونتهای لوکال را در تب <a target="_blank" href="admin.php?page=be-options#performance-general">عملکرد</a> انتخاب کنید. </p>
							<p>بازتولید هنگامی که تغییری در تب <a target="_blank" href="admin.php?page=be-options#font-family">Fonts &gt; Family</a> ایجاد میشود. </p>
							<a data-nonce="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>" data-action="mfn_regenerate_fonts" href="#" class="mfn-btn mfn-btn-fw tools-do-ajax">
								<span class="btn-wrapper"><?php esc_html_e( 'Regenerate fonts', 'mfn-opts' ); ?></span>
							</a>
						</div>
					</div>

				</div>

				<div class="row-column row-column-4">

					<div class="mfn-card mfn-shadow-1" data-card="tool-item">
						<div class="card-content">
							<div class="tool-logo">
								<span class="delete-history">پاک کردن <b>تاریخچه</b>
								</span>
							</div>
							<p>تاریخچه بی بیلدر را پاک کن</p>
							<a data-nonce="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>" data-action="mfn_history_delete" href="#" class="mfn-btn mfn-btn-fw tools-do-ajax confirm">
								<span class="btn-wrapper"><?php esc_html_e( 'Delete', 'mfn-opts' ); ?></span>
							</a>
						</div>
					</div>

				</div>

				<div class="row-column row-column-4">

					<div class="mfn-card mfn-shadow-1" data-card="tool-item">
						<div class="card-content">
							<div class="tool-logo">
								<span class="regenerate-thumbnails">بازتولید <b>تصاویر بند انگشتی</b>
								</span>
							</div>
							<p>بازتولید سایزهای متفاوت تصاویر</p>
							<p>بعد از نصب <a target="_blank" href="admin.php?page=be-websites">یک وبسایت آماده</a> مفید است.</p>
							<a data-nonce="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>" data-action="mfn_regenerate_thumbnails" href="#" class="mfn-btn mfn-btn-fw mfn-regenerate-thumbnails">
								<span class="btn-wrapper"><?php esc_html_e( 'Regenerate thumbnails', 'mfn-opts' ); ?></span>
							</a>
						</div>
					</div>

				</div>

			</div>
		</div>

		<?php
			// footer
			include_once get_theme_file_path('/functions/admin/templates/parts/footer.php');
		?>

	</div>

</div>
