<?php
	defined( 'ABSPATH' ) || exit;
?>

<div id="mfn-dashboard" class="mfn-ui mfn-dashboard" data-page="support">

	<input type="hidden" name="mfn-builder-nonce" value="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>">

	<?php
		// header
		include_once get_theme_file_path('/functions/admin/templates/parts/header.php');
	?>

	<div class="mfn-wrapper">

		<?php
			// subheader
			$current = 'support';
			include_once get_theme_file_path('/functions/admin/templates/parts/subheader.php');
		?>

		<div class="mfn-dashboard-wrapper">

			<div class="mfn-row">

				<div class="row-column row-column-8">

					<div class="mfn-card mfn-shadow-1" data-card="video">
						<div class="card-content">
							<iframe width="711" height="400" src="https://www.youtube.com/embed/MkeTBSMQEIE" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
						</div>
					</div>

					<div class="mfn-card mfn-shadow-1" data-card="last-videos">

						<div class="card-header">
							<div class="card-title-group">
								<span class="card-icon mfn-icon-card"></span>
								<div class="card-desc">
									<h4 class="card-title">ویدیوها برای شروع کار</h4>
								</div>
							</div>
							<div class="card-links-group">
								<a target="_blank" href="https://support.muffingroup.com/video-tutorials/">
									<span class="mfn-icon mfn-icon-layout-grid"></span> نمایش همه خودآموزها </a>
							</div>
						</div>

						<div class="card-content">
							<ul class="last-videos-list">
								<li>
									<a href="https://www.youtube.com/watch?v=fj1_NO8meJQ" class="lightbox">
										<img src="https://support.muffingroup.com/wp-content/uploads/2022/07/header-builder-2.webp" alt="" />
										<i class="fab fa-youtube play-icon"></i>
									</a>
									<h5>سازنده سربرگ</h5>
								</li>
								<li>
									<a href="https://www.youtube.com/watch?v=qDabDsmoct4" class="lightbox">
										<img src="https://support.muffingroup.com/wp-content/uploads/2022/07/footer-builder.webp" alt="" />
										<i class="fab fa-youtube play-icon"></i>
									</a>
									<h5>سازنده فوتر (پاورقی)</h5>
								</li>
								<li>
									<a href="https://www.youtube.com/watch?v=AvIN8hfomBc" class="lightbox">
										<img src="https://support.muffingroup.com/wp-content/uploads/2022/07/mega-menu-builder.webp" alt="" />
										<i class="fab fa-youtube play-icon"></i>
									</a>
									<h5>ساخت مگا منو</h5>
								</li>
								<li>
									<a href="https://www.youtube.com/watch?v=8gRTpdSHF9U" class="lightbox">
										<img src="https://support.muffingroup.com/wp-content/uploads/2022/03/responsive-editing.webp" alt="" />
										<i class="fab fa-youtube play-icon"></i>
									</a>
									<h5>ویرایش رسپانسیو</h5>
								</li>
							</ul>
						</div>

					</div>

					<div class="mfn-card mfn-shadow-1" data-card="support-info">
						<div class="card-content">
							<div class="mfn-row">
								<div class="row-column row-column-6 support-item">
									<span class="support-icon mfn-icon-yes-green"></span>
									<h5>موارد که شامل پشتیبانی ما <span class="include">میشود</span>: </h5>
									<p>مشکلات موجود در قالب</p>
								</div>
								<div class="row-column row-column-6 support-item">
									<span class="support-icon mfn-icon-no-red"></span>
									<h5>موارد که شامل پشتیبانی ما  <span class="include">نمیشود</span>: </h5>
									<p>نصب و درون ریزی</p>
									<p>آموزش</p>
									<p>موارد مربوط به افزونه ها</p>
								</div>
							</div>
						</div>
					</div>

				</div>

				<div class="row-column row-column-4">

					

					<div class="mfn-card mfn-shadow-1" data-card="support-documentation">
						<div class="card-content">
							<div class="mfn-icon-box">
								<div class="image-wrapper">
									<img class="icon-light" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg//support-docs.svg'); ?>" alt="" />
									<img class="icon-dark" src="<?php echo get_theme_file_uri('/functions/admin/assets/svg/_dark/support-docs.svg'); ?>" alt="" />
								</div>
								<div class="desc-wrapper">
									<h5 class="heading">مستندات و راهنمای قالب</h5>
									<p>کتابچه تنظیمات و راهنمای ویژگی ها</p>
									<a target="_blank" href="https://support.muffingroup.com/documentation/">برو به مستندات</a>
								</div>
							</div>
						</div>
					</div>

					

				</div>
			</div>

		</div>

		<?php
			// footer
			include_once get_theme_file_path('/functions/admin/templates/parts/footer.php');
		?>

	</div>

</div>
