(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[4],{150:function(module,exports,__webpack_require__){"use strict";eval('\n\n/* global YoastCustomFieldsPluginL10 */\n/* global YoastSEO */\n/* global _ */\n(function () {\n\t/**\n  * The Yoast Custom Fields Plugin adds the custom fields to the content that were defined in the titles and meta\'s\n  * section of the Yoast SEO settings when those fields are available.\n  *\n  * @constructor\n  * @property {Array} customFieldNames\n  * @property {Object} customFields\n  */\n\tvar YoastCustomFieldsPlugin = function YoastCustomFieldsPlugin() {\n\t\tYoastSEO.app.registerPlugin("YoastCustomFieldsPlugin", { status: "loading" });\n\n\t\tthis.customFields = {};\n\n\t\tthis.updateCustomFields();\n\t\tthis.declareReady();\n\t};\n\n\t/**\n  * Declares ready with YoastSEO.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.declareReady = function () {\n\t\tYoastSEO.app.pluginReady("YoastCustomFieldsPlugin");\n\t\tYoastSEO.app.registerModification("content", this.addCustomFields.bind(this), "YoastCustomFieldsPlugin");\n\t};\n\n\t/**\n  * Declares reloaded with YoastSEO.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.declareReloaded = function () {\n\t\tYoastSEO.app.pluginReloaded("YoastCustomFieldsPlugin");\n\t};\n\n\t/**\n  * The callback used to add the custom fields to the content to be analyzed by YoastSEO.js.\n  *\n  * @param {String} content The content for adding the custom fields to.\n  * @returns {String} The content.\n  */\n\tYoastCustomFieldsPlugin.prototype.addCustomFields = function (content) {\n\t\tfor (var fieldName in this.customFields) {\n\t\t\tcontent += " ";\n\t\t\tcontent += this.customFields[fieldName];\n\t\t}\n\t\treturn content;\n\t};\n\n\t/**\n  * Fetches the relevant custom fields from the form and saves them in a property.\n  * Then declares reloaded and rebinds the custom fields form.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.updateCustomFields = function () {\n\t\tvar customFields = {};\n\t\tjQuery("#the-list > tr:visible").each(function (i, el) {\n\t\t\tvar customFieldName = jQuery("#" + el.id + "-key").val();\n\t\t\tif (YoastCustomFieldsPluginL10.custom_field_names.indexOf(customFieldName) !== -1) {\n\t\t\t\tcustomFields[customFieldName] = jQuery("#" + el.id + "-value").val();\n\t\t\t}\n\t\t});\n\t\tthis.customFields = customFields;\n\t\tthis.declareReloaded();\n\t\tthis.bindCustomFields();\n\t};\n\n\t/**\n  * Adds the necessary event bindings for monitoring which custom fields are added/removed/updated.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.bindCustomFields = function () {\n\t\tvar callback = _.debounce(this.updateCustomFields.bind(this), 500, true);\n\n\t\tjQuery("#the-list .button + .update_meta").off("click.wpseoCustomFields").on("click.wpseoCustomFields", callback);\n\t\tjQuery("#the-list").off("wpListDelEnd.wpseoCustomFields").on("wpListDelEnd.wpseoCustomFields", callback);\n\t\tjQuery("#the-list").off("wpListAddEnd.wpseoCustomFields").on("wpListAddEnd.wpseoCustomFields", callback);\n\t\tjQuery("#the-list textarea").off("input.wpseoCustomFields").on("input.wpseoCustomFields", callback);\n\t};\n\n\tif (typeof YoastSEO !== "undefined" && typeof YoastSEO.app !== "undefined") {\n\t\tnew YoastCustomFieldsPlugin();\n\t} else {\n\t\tjQuery(window).on("YoastSEO:ready", function () {\n\t\t\tnew YoastCustomFieldsPlugin();\n\t\t});\n\t}\n})();//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///150\n')}},[[150,0]]]);