<?php
?>
<div id="scrapes-support" class="wrap about-wrap">
	<div class="bws-wrap">
		<h1><?php echo esc_html_e('Help and Support', 'ol-scrapes'); ?></h1>	
        <div class="w-row">
            <div class="s-col-sm-2">
                <div class="w-box support-page videobox">
                    <div class="w-box-content">
                        <h3><?php _e('Get started with the Scrapes plugin', 'ol-scrapes'); ?></h3>
						<p style="margin-top:20px;"><?php esc_html_e('In this short video, the plugin and how to install it are introduced, you can download the full video from the Zhaket user panel.' , 'ol-scrapes'); ?></p>
                    </div>
					<div class="w-box-content section-ifarme">    
						<iframe width="784" height="441" src="https://www.aparat.com/video/video/embed/videohash/4T2dv/vt/frame" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
					</div>
					<div class="w-box-content"> 	
						<a href="https://www.zhaket.com/dashboard/downloads" target="_blank"><?php echo esc_html__('Download Video from Zhaket', 'ol-scrapes'); ?></a>
                    </div>
                </div>
            </div>			
        </div>
		<div class="w-row">
			<div class="s-col-sm-2">
				<div class="w-box google-script-help">
					<div class="w-box-head">
						<?php echo esc_html__('Google Script Help', 'ol-scrapes'); ?>
					</div>					
					<div class="scrapes-accordion">
						<div class="scrapes-accordion-trigger"><a href=""><?php echo esc_html__('Google Script Help', 'ol-scrapes'); ?></a></div>
						<div class="scrapes-accordion-content">
							<p><?php _e('Using Google Script, you can use it as a proxy to extract information from sites that are banned in Iran. To setup Google Script, you must do it the steps below :', 'ol-scrapes'); ?></p>
							<ul>
								<li><?php _e('1- Go to google script and sign in if required. ', 'ol-scrapes'); ?><a href="https://script.google.com/" target="_blank">script.google.com</a></li>
								<li><?php _e('2- Create a new project and give it a name', 'ol-scrapes'); ?></li>
								<li><?php _e('3- open Code.gs file. Remove the contents of this file', 'ol-scrapes'); ?></li>
								<li><?php _e('4- Copy the contents of below code and paste into your project file', 'ol-scrapes'); ?></li>
								<li><?php _e('5- Click Save project or press Ctrl+S', 'ol-scrapes'); ?></li>
								<li><?php _e('6- Click "Deploy" from the menu and select "New deployment"', 'ol-scrapes'); ?></li>
								<li><?php _e('7- Select "Web app" from the section "Select type"', 'ol-scrapes'); ?></li>
								<li><?php _e('8- In "Disciption", enter a short description', 'ol-scrapes'); ?></li>
								<li><?php _e('9- In "Execute as", select "Me (your email)"', 'ol-scrapes'); ?></li>
								<li><?php _e('10- In "Who has access", select "Anyone"', 'ol-scrapes'); ?></li>
								<li><?php _e('11- Click "Deploy" to open the Authorization box', 'ol-scrapes'); ?></li>
								<li><?php _e('12- Click "Review Permissions" to authorize the script', 'ol-scrapes'); ?></li>
								<li><?php _e('13- In the popup window select your Google Account', 'ol-scrapes'); ?></li>
								<li><?php _e('14- On the next screen, click "Allow"', 'ol-scrapes'); ?></li>					
								<li><?php _e('15- Copy the "Current web app URL" and paste it in plugin', 'ol-scrapes'); ?></li>
							</ul>
							<textarea cols="30" class="ltr" rows="5" onfocus="this.select();" onmouseup="return false;" readonly>
function doGet(e) {   
    if(typeof e !== 'undefined'){ 
      var request = getdata(e);
      var response = ContentService.createTextOutput(request);
      return response;
    }
}

function getdata(e) {
  if(typeof e.parameter.cookie !== 'undefined'){
    var cookie = e.parameter.cookie;
  } else {
    var cookie = '';
  }
  var options = {
    "method": "get",
    "headers" : {"Cookie" : cookie},
	"muteHttpExceptions": true
  }  
  var url = e.parameter.url;
  var data = UrlFetchApp.fetch(url, options);
  return data.getContentText();
}							
							</textarea>
						</div>						
					</div>
					<?php wp_enqueue_script('google-script-help', plugins_url("assets/js/support.js", dirname(__FILE__)), null, OL_VERSION); ?>						
				</div>	
			</div>
		</div>			
		<div class="w-row">
			<div class="s-col-sm-2">
				<div class="w-box support-page bws-ticksy">
					<div class="w-box-content">
						<center><img src="<?php echo plugin_dir_url(__FILE__ ) . '../assets/img/wn-ms-icon-17-n.svg'; ?>" style="width:100px; margin-top:30px;" /></center>
						<p style="margin-top:20px;"><?php esc_html_e('Bargwp provides Persian WordPress services at your service. If you have any problems, please contact us, we will respond as soon as possible.' , 'ol-scrapes'); ?><?php echo sprintf(__("<br><small style=\"color: #8a8a8a;\">You can send your questions and problems through the support ticket.</small>", 'ol-scrapes'));?></p>
						<a href="https://www.zhaket.com/dashboard/tickets" target="_blank"><?php esc_html_e('Create a support ticket','ol-scrapes'); ?></a>
					</div>
				</div>	
			</div>
		</div>
		<?php if (is_rtl()): ?>
        <div class="w-row">
            <div class="s-col-sm-2">
                <div class="w-box change-log">
                    <div class="w-box-head">
                        <?php echo esc_html__('Change Log', 'ol-scrapes'); ?>
                    </div>
                    <div class="w-box-content">					    
						<pre><?php echo file_get_contents(plugin_dir_path(__FILE__ ).'../changelog.txt'); ?></pre>					
                    </div>
                </div>
            </div>
        </div>
		<?php endif; ?>
	</div>
</div>	