<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

$scrape_filters_fields = unserialize($meta_vals['scrape_filters_fields'][0]);
$scrape_filters_operators = unserialize($meta_vals['scrape_filters_operators'][0]);
$scrape_filters_values = unserialize($meta_vals['scrape_filters_values'][0]);

for ($i = 0; $i < count($scrape_filters_fields); $i++) {

	$field = $scrape_filters_fields[$i];
	$operator = $scrape_filters_operators[$i];
	$value = $scrape_filters_values[$i];


	if ($field == 'title') {
		$actual_value = $post_arr['post_title'];
	} else if ($field == 'content') {
		$actual_value = $post_arr['post_content'];
	} else if ($field == 'excerpt') {
		$actual_value = $post_arr['post_excerpt'];
	} else if ($field == 'featured_image') {
		$actual_value = $post_featured_image_url;
	} else if ($field == 'date') {
		$actual_value = $save_post_date_jalali;
	} else if (strpos($field, 'custom_field_') === 0) {
		$exploded = explode('_', $field);
		$exploded = end($exploded);
		$actual_value = $post_arr['meta_input'][$scrape_custom_fields[$exploded]['name']];
	}

	if ($operator == 'not_exists') {
		if (is_null($actual_value)) {
			$this->write_log('post filter applied: ' . var_export($actual_value, true) . ' operator : ' . $operator . ' ' . $value, 'warning');
			$result_filter = true;
			return;
		}
	}

	if ($operator == 'exists') {
		if (!is_null($actual_value)) {
			$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
			$result_filter = true;
			return;
		}
	}
	if ($operator == 'does_not_contain') {
		if (is_string($actual_value)) {
			if (stripos($actual_value, $value) === false) {
				$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
				$result_filter = true;
				return;
			}
		} else if (is_array($actual_value)) {
			if (!in_array($value, $actual_value)) {
				$this->write_log('post filter applied: ' . var_export($actual_value, true) . ' operator : ' . $operator . ' ' . $value, 'warning');
				$result_filter = true;
				return;
			}
		}
	}

	if ($operator == 'not_equal_to') {
		if ($actual_value != $value) {
			$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
			$result_filter = true;
			return;
		}
	}

	if ($operator == 'contains') {
		if (is_string($actual_value)) {
			if (stripos($actual_value, $value) !== false) {
				$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
				$result_filter = true;
				return;
			}
		} else if (is_array($actual_value)) {
			if (in_array($value, $actual_value)) {
				$this->write_log('post filter applied: ' . var_export($actual_value, true) . ' operator : ' . $operator . ' ' . $value, 'warning');
				$result_filter = true;
				return;
			}
		}
	}

	if ($operator == 'equal_to') {
		if ($actual_value == $value) {
			$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
			$result_filter = true;
			return;
		}
	}

	if ($operator == 'less_than') {
		if ($actual_value < $value) {
			$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
			$result_filter = true;
			return;
		}
	}

	if ($operator == 'greater_than') {
		if ($actual_value > $value) {
			$this->write_log('post filter applied: ' . $actual_value . ' operator : ' . $operator . ' ' . $value, 'warning');
			$result_filter = true;
			return;
		}
	}
}