<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

$product_gallery_ids = array();

if( empty($post_meta_allowhtmls[$i_allowhtml]) ) 
{	
	$this->write_log('image gallery process starts for WooCommerce');
	$woo_img_xpath = $post_meta_values[array_search('_product_image_gallery', $post_meta_names)];
	$woo_img_xpath = $woo_img_xpath . "//img | " . $woo_img_xpath . "//a | " . $woo_img_xpath . "//div |" . $woo_img_xpath . "//li";
	$nodes = $xpath->query($woo_img_xpath);
	$this->write_log("Gallery images length is " . $nodes->length);
	
	$max_width = 0;
	$max_height = 0;
	$gallery_images = array();
	foreach ($nodes as $img) {
		$post_meta_index = array_search('_product_image_gallery', $post_meta_names);
		$attr = $post_meta_attributes[$post_meta_index];
		if (empty($attr)) {
			if ($img->nodeName == "img") {
				$attr = 'src';
			} else {
				$attr = 'href';
			}
		}
		$img_url = trim($img->getAttribute($attr));
		if (!empty($post_meta_regex_statuses[$post_meta_index])) {
			$regex_combined = array_combine($post_meta_regex_finds[$post_meta_index], $post_meta_regex_replaces[$post_meta_index]);
			foreach ($regex_combined as $find => $replace) {
				$this->write_log("custom field value before regex $img_url");
				$img_url = preg_replace("/" . str_replace("/", "\/", $find) . "/isu", $replace, $img_url);
				$this->write_log("custom field value after regex $img_url");
			}
		}
		$img_abs_url = $this->image_fn->create_absolute_url($img_url, $url, $html_base_url);
		$this->write_log($img_abs_url);
		$is_base64 = false;
		if (substr($img_abs_url, 0, 11) == 'data:image/') {
			$array_result = getimagesizefromstring(base64_decode(substr($img_abs_url, strpos($img_abs_url, 'base64') + 7)));
			$is_base64 = true;
		} else {
			
			$args = Scrape_Featured_IMage::return_html_args($meta_vals);
			
			$image_req = wp_remote_get($img_abs_url, $args);
			if (is_wp_error($image_req)) {
				$this->write_log("http error in " . $img_abs_url . " " . $image_req->get_error_message(), true);
				$array_result = false;
			} else {
				$array_result = getimagesizefromstring($image_req['body']);
			}
			
		}
		if ($array_result !== false) {
			$width = $array_result[0];
			$height = $array_result[1];
			if ($width > $max_width) {
				$max_width = $width;
			}
			if ($height > $max_height) {
				$max_height = $height;
			}
			
			$gallery_images[] = array(
				'width' => $width, 'height' => $height, 'url' => $img_abs_url, 'is_base64' => $is_base64
			);
		} else {
			$this->write_log("Image size data could not be retrieved", true);
		}
	}
	
	$this->write_log("Max width found: " . $max_width . " Max height found: " . $max_height);
	foreach ($gallery_images as $gi) {
		if ($gi['is_base64']) {
			continue;
		}
		$old_url = $gi['url'];
		$width = $gi['width'];
		$height = $gi['height'];
		
		$offset = 0;
		$width_pos = array();
		
		while (strpos($old_url, strval($width), $offset) !== false) {
			$width_pos[] = strpos($old_url, strval($width), $offset);
			$offset = strpos($old_url, strval($width), $offset) + 1;
		}
		
		$offset = 0;
		$height_pos = array();
		
		while (strpos($old_url, strval($height), $offset) !== false) {
			$height_pos[] = strpos($old_url, strval($height), $offset);
			$offset = strpos($old_url, strval($height), $offset) + 1;
		}
		
		$min_distance = PHP_INT_MAX;
		$width_replace_pos = 0;
		$height_replace_pos = 0;
		foreach ($width_pos as $wr) {
			foreach ($height_pos as $hr) {
				$distance = abs($wr - $hr);
				if ($distance < $min_distance && $distance != 0) {
					$min_distance = $distance;
					$width_replace_pos = $wr;
					$height_replace_pos = $hr;
				}
			}
		}
		$min_pos = min($width_replace_pos, $height_replace_pos);
		$max_pos = max($width_replace_pos, $height_replace_pos);
		
		$new_url = "";
		
		if ($min_pos != $max_pos) {
			$this->write_log("Different pos found not square");
			$new_url = substr($old_url, 0, $min_pos) . strval($max_width) . substr($old_url, $min_pos + strlen($width), $max_pos - ($min_pos + strlen($width))) . strval($max_height) . substr($old_url, $max_pos + strlen($height));
		} else {
			if ($min_distance == PHP_INT_MAX && strpos($old_url, strval($width)) !== false) {
				$this->write_log("Same pos found square image");
				$new_url = substr($old_url, 0, strpos($old_url, strval($width))) . strval(max($max_width, $max_height)) . substr($old_url, strpos($old_url, strval($width)) + strlen($width));
			}
		}
		
		$this->write_log("Old gallery image url: " . $old_url);
		$this->write_log("New gallery image url: " . $new_url);
		if ($is_amazon) {
			$new_url = preg_replace("/\._.*_/", "", $old_url);
		}
		
		if( !empty($meta_vals['scrape_external_image'][0]) ) {
			if( !empty($old_url) && empty($new_url) ) {
				$new_url = $old_url;
			}
			$pgi_id = Scrape_External_Images::thumbnail_url_external_save($new_id, $new_url, $post_arr['post_title'], false);
		} else {
			$pgi_id = Scrape_Featured_IMage::generate_featured_image($new_url, $new_id, false);
		}
		
		if (!empty($pgi_id)) {
			$product_gallery_ids[] = $pgi_id;
		} else {
			if( !empty($meta_vals['scrape_external_image'][0]) ) {
				$pgi_id = Scrape_External_Images::thumbnail_url_external_save($new_id, $old_url, $post_arr['post_title'], false);
			} else {
				$pgi_id = Scrape_Featured_IMage::generate_featured_image($old_url, $new_id, false);
			}
			if (!empty($pgi_id)) {
				$product_gallery_ids[] = $pgi_id;
			}
		}
	}
}

$i_get_json = array_search('_product_image_gallery', $post_meta_names);

if( !empty($post_meta_get_json[$i_get_json]) )
{
	$gallery_json = $meta_input['_product_image_gallery'];
	$gallery_json = $this->requir_fn->get_value_from_json($gallery_json, $post_meta_attributes[$i_get_json], true);
	
	foreach($gallery_json as $old_url) {
		if( !empty($meta_vals['scrape_external_image'][0]) ) {
			$pgi_id = Scrape_External_Images::thumbnail_url_external_save($new_id, $old_url, $post_arr['post_title'], false);
		} else {
			$pgi_id = Scrape_Featured_IMage::generate_featured_image($old_url, $new_id, false);
		}
		if (!empty($pgi_id)) {
			$product_gallery_ids[] = $pgi_id;
		}						
	}	
}

if(!empty($post_meta_allowhtmls[$i_allowhtml]) && empty($post_meta_dont_updates[$i_dont_update])) 
{	
	$gallery_images = $meta_input['_product_image_gallery'];
	$gallery_images = preg_match_all('/data-high-res-src="([^"]*)"/', $gallery_images, $matches);
	$gallery_images = array_unique($matches[1]);
	
	foreach($gallery_images as $old_url) {
		if( !empty($meta_vals['scrape_external_image'][0]) ) {
			$pgi_id = Scrape_External_Images::thumbnail_url_external_save($new_id, $old_url, $post_arr['post_title'], false);
		} else {
			$pgi_id = Scrape_Featured_IMage::generate_featured_image($old_url, $new_id, false);
		}
		if (!empty($pgi_id)) {
			$product_gallery_ids[] = $pgi_id;
		}						
	}
	
} elseif(!empty($post_meta_allowhtmls[$i_allowhtml]) && !empty($post_meta_dont_updates[$i_dont_update]) && empty($meta_vals_of_post['_product_image_gallery'][0])) 
{
	$gallery_images = $meta_input['_product_image_gallery'];
	$gallery_images = preg_match_all('/data-high-res-src="([^"]*)"/', $gallery_images, $matches);
	$gallery_images = array_unique($matches[1]);
	
	foreach($gallery_images as $old_url) {
		if( !empty($meta_vals['scrape_external_image'][0]) ) {
			$pgi_id = Scrape_External_Images::thumbnail_url_external_save($new_id, $old_url, $post_arr['post_title'], false);
		} else {
			$pgi_id = Scrape_Featured_IMage::generate_featured_image($old_url, $new_id, false);
		}
		if (!empty($pgi_id)) {
			$product_gallery_ids[] = $pgi_id;
		}						
	}
	
} elseif(!empty($post_meta_dont_updates[$i_dont_update]) && !empty($meta_vals_of_post['_product_image_gallery'][0])) 
{
	$attachment_ids = $meta_vals_of_post['_product_image_gallery'][0];
	$product_gallery_ids = explode(',', $attachment_ids);					
}

update_post_meta($new_id, '_product_image_gallery', implode(",", array_unique($product_gallery_ids)));