<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

/**
 * Bargwp Featured image class
 * @author Bargwp <info@bargwp.com>
 */
 
class Scrape_Featured_IMage {
	
	/**
     * Instance of this class. This is a singleton class
     */
	private static $instance = NULL;    
	
	/**
     * Getting instance. This Class is a singleton class
     * @return static
     */	
    public static function instance() {
        // Get an instance of Class
        if(!self::$instance) self::$instance = new self();
        
        // Return the instance
        return self::$instance;
	}	
	
	public static function generate_featured_image($image_url, $post_id, $featured = true) 
	{
		OL_Scrapes::write_log($image_url . " thumbnail controls");
		$meta_vals = get_post_meta(OL_Scrapes::$task_id);
        $parent_post_title = get_the_title($post_id);
		$upload_dir = wp_upload_dir();
		
		global $wpdb;
		$query = "SELECT ID FROM {$wpdb->posts} WHERE post_content LIKE '" . md5($image_url) . "%' and post_type ='attachment' and post_parent = $post_id";
		$image_id = $wpdb->get_var($query);
		
		OL_Scrapes::write_log("found image id for $post_id : " . $image_id);		
		
		if (empty($image_id)) {

            $filename = sanitize_file_name(sanitize_title($parent_post_title) . '_' . uniqid());
			
			if( class_exists('Top_Rank_Seo') ) {
				if( Top_Rank_Admin::tpr_get_options( 'active_image_name' ) == 1 ) {
					
					if (preg_match("/(\/|\.)digikala\./", $meta_vals['scrape_url'][0])) {
						$filename = preg_match('/.*\/(.*?)\./', $image_url, $match);
						$filename = $match[1];
					} else {
						$filename = pathinfo($image_url, PATHINFO_FILENAME);
					}
				}
			}

			if (wp_mkdir_p($upload_dir['path'])) {
				$file = $upload_dir['path'] . '/' . $filename;
			} else {
				$file = $upload_dir['basedir'] . '/' . $filename;
			}
			
			if (substr($image_url, 0, 11) == 'data:image/') {
				$image_data = array(
					'body' => base64_decode(substr($image_url, strpos($image_url, 'base64') + 7))
				);
			} else {
				$args = self::return_html_args($meta_vals);
				
				$image_data = wp_remote_get($image_url, $args);
				if (is_wp_error($image_data)) {
					OL_Scrapes::write_log("http error in " . $image_url . " " . $image_data->get_error_message(), true);
					return;
				}
			}
			
			$mimetype = getimagesizefromstring($image_data['body']);
			if ($mimetype === false) {
				OL_Scrapes::write_log("mime type of image can not be found");
				OL_Scrapes::write_log(substr($image_data['body'], 0, 150));
				return;
			}
			
			$mimetype = $mimetype["mime"];
			$extension = substr($mimetype, strpos($mimetype, "/") + 1);
			$file .= ".$extension";
			
			file_put_contents($file, $image_data['body']);
			
			$attachment = array(
				'post_mime_type' => $mimetype,
                'post_title' => $parent_post_title . '_' . uniqid() . '.' . $extension,
                'post_content' => md5($image_url),
                'post_status' => 'inherit'
			);
			
			if (!empty($meta_vals['scrape_watermark_images'][0])) {
				if( class_exists('Image_Watermark')) {
					$image_watermark = new Image_Watermark();
					$image_watermark->do_watermark( $post_id, $file, $mimetype, $upload_dir, $attachment );
				}
			}				
			
			$attach_id = wp_insert_attachment($attachment, $file, $post_id);
			
			OL_Scrapes::write_log("attachment id : " . $attach_id . " mime type: " . $mimetype . " added to media library.");
			
			require_once(ABSPATH . 'wp-admin/includes/image.php');
			$attach_data = wp_generate_attachment_metadata($attach_id, $file);
			wp_update_attachment_metadata($attach_id, $attach_data);
			if ($featured) {
				set_post_thumbnail($post_id, $attach_id);
			}
			self::add_alt_to_images($attach_id, $parent_post_title);
			
			unset($attach_data);
			unset($image_data);
			unset($mimetype);
			return $attach_id;
		} else {
			if ($featured) {
				OL_Scrapes::write_log("image already exists set thumbnail for post " . $post_id . " to " . $image_id);
				set_post_thumbnail($post_id, $image_id);
			}
			self::add_alt_to_images($image_id, $parent_post_title);
		}
		return $image_id;
	}
	
	public static function add_alt_to_images($img_id, $title) {

		if( class_exists('Top_Rank_Seo') ) {
			
			if( Top_Rank_Admin::tpr_get_options( 'active_image_alt' ) == 1 ) {
				
				$image_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
					
				if( empty($image_alt) ) {
					update_post_meta($img_id, '_wp_attachment_image_alt', $title);
					OL_Scrapes::write_log("The alt feature added to the image with id $img_id");
				}				
			}
		}	
	}
	
	public function add_attachment_from_url($attachment_url, $post_id) {
		OL_Scrapes::write_log($attachment_url . " attachment controls");
		$meta_vals = get_post_meta(OL_Scrapes::$task_id);
		$upload_dir = wp_upload_dir();
		
		$parsed = parse_url($attachment_url);
		$filename = basename($parsed['path']);
		
		global $wpdb;
		$query = "SELECT ID FROM {$wpdb->posts} WHERE post_title LIKE '" . $filename . "%' and post_type ='attachment' and post_parent = $post_id";
		$attachment_id = $wpdb->get_var($query);
		
		OL_Scrapes::write_log("found attachment id for $post_id : " . $attachment_id);
		
		if (empty($attachment_id)) {
			if (wp_mkdir_p($upload_dir['path'])) {
				$file = $upload_dir['path'] . '/' . $filename;
			} else {
				$file = $upload_dir['basedir'] . '/' . $filename;
			}
			
			$args = self::return_html_args($meta_vals);
			
			$file_data = wp_remote_get($attachment_url, $args);
			if (is_wp_error($file_data)) {
				OL_Scrapes::write_log("http error in " . $attachment_url . " " . $file_data->get_error_message(), true);
				return;
			}
			
			
			$mimetype = wp_check_filetype($filename);
			if ($mimetype === false) {
				OL_Scrapes::write_log("mime type of image can not be found");
				return;
			}
			
			$mimetype = $mimetype['type'];
			$extension = isset($mimetype['ext']) ? $mimetype['ext'] : '';
			
			file_put_contents($file, $file_data['body']);
			
			$attachment = array(
				'post_mime_type' => $mimetype, 'post_title' => $filename . ".$extension", 'post_content' => '', 'post_status' => 'inherit'
			);
			
			$attach_id = wp_insert_attachment($attachment, $file, $post_id);
			
			OL_Scrapes::write_log("attachment id : " . $attach_id . " mime type: " . $mimetype . " added to media library.");
			
			require_once(ABSPATH . 'wp-admin/includes/image.php');
			$attach_data = wp_generate_attachment_metadata($attach_id, $file);
			wp_update_attachment_metadata($attach_id, $attach_data);
			return $attach_id;
		}
		return $attachment_id;
	}	

	public static function return_html_args($meta_vals = null) 
	{
		$selector = isset($_GET['selector']) ? $_GET['selector'] : 'default';
		$body = array();
		
		if(is_null($meta_vals) && $selector == 'google_script') {
			$body = array('url' => isset($_GET['address']) ? $_GET['address'] : '');
		} 
		elseif(isset($meta_vals['scrape_selector']) && $meta_vals['scrape_selector'] == 'google_script') 
		{
			$body = array('url' => isset($meta_vals['scrape_url']) ? $meta_vals['scrape_url'][0] : '');
		}
		$args = array(
			'sslverify' => false, 'timeout' => is_null($meta_vals) ? 60 : $meta_vals['scrape_timeout'][0], 'user-agent' => get_site_option('scrape_user_agent'), 'redirection' => 10, 
			'body' => $body
			//'httpversion' => '1.1',
			//'headers' => array('Connection' => 'keep-alive')
		);
		if (isset($_GET['cookie_names'])) {
			$args['cookies'] = array_combine(array_values($_GET['cookie_names']), array_values($_GET['cookie_values']));
		}
		if (!empty($meta_vals['scrape_cookie_names'])) {
			$args['cookies'] = array_combine(array_values(unserialize($meta_vals['scrape_cookie_names'][0])), array_values(unserialize($meta_vals['scrape_cookie_values'][0])));
		}
		return $args;
	}

	public function get_orginal_image_link_from_content($orgi_html) {
		$doc = new DOMDocument();
		$doc->preserveWhiteSpace = false;
		@$doc->loadHTML('<?xml encoding="utf-8" ?>' . $orgi_html);
		$org_image = $doc->getElementsByTagName('img');
		if ($org_image->length) {
			foreach ($org_image as $itemnew) {
				if ($itemnew->getAttribute('data-lazy-src') != '') {
					$get_image[] = $itemnew->getAttribute('data-lazy-src');
				} elseif ($itemnew->getAttribute('data-src') != '') {
					$get_image[] = $itemnew->getAttribute('data-src');
				} elseif ($itemnew->getAttribute('src') != '') {
					$get_image[] = $itemnew->getAttribute('src');
				}
			}
		}

		return $get_image;
	}
	
	public function fix_image_link_content($html_string, $original_html_string) {
		if (empty($html_string)) {
			return "";
		}
		$new_image = $this->get_orginal_image_link_from_content($original_html_string);
		$doc = new DOMDocument();
		$doc->preserveWhiteSpace = false;
		@$doc->loadHTML('<?xml encoding="utf-8" ?>' . $html_string);
		$imgs = $doc->getElementsByTagName('img');
		if ($imgs->length) {
			$i = 0;
			foreach ($imgs as $itemold) {
				if ($itemold->getAttribute('src') != '') {
					$old_image[] = $itemold->getAttribute('src');
					$itemold->setAttribute('src', $new_image[$i]);
				}
				$i++;
			}
		}		
		
		return $this->save_html_clean($doc);
	}

	public function download_images_from_html_string($html_string, $post_id) {
		if (empty($html_string)) {
			return "";
		}
		$doc = new DOMDocument();
		$doc->preserveWhiteSpace = false;
		@$doc->loadHTML('<?xml encoding="utf-8" ?>' . $html_string);
		$imgs = $doc->getElementsByTagName('img');
		if ($imgs->length) {
			foreach ($imgs as $item) {
				
				$image_url = $item->getAttribute('src');
				global $wpdb;
				$query = "SELECT ID FROM {$wpdb->posts} WHERE post_title LIKE '" . md5($image_url) . "%' and post_type ='attachment' and post_parent = $post_id";
				$count = $wpdb->get_var($query);
				
				OL_Scrapes::write_log("download image id for post $post_id is " . $count);
				
				if (empty($count)) {
					$attach_id = $this->generate_featured_image($image_url, $post_id, false);
					$item->setAttribute('src', wp_get_attachment_url($attach_id));
				} else {
					$item->setAttribute('src', wp_get_attachment_url($count));
				}
				$item->removeAttribute('srcset');
				$item->removeAttribute('sizes');
				unset($image_url);
			}
		}
		
		return $this->save_html_clean($doc);
	}
	
	public function convert_html_links($html_string, $base_url, $html_base_url, $title = '') {
		if (empty($html_string)) {
			return "";
		}
		$toprank = false;
		if( class_exists('Top_Rank_Seo') ) {
			if( Top_Rank_Admin::tpr_get_options( 'active_image_alt' ) == 1 ) {
				$toprank = true;
			}
		}
		$doc = new DOMDocument();
		$doc->preserveWhiteSpace = false;
		@$doc->loadHTML('<?xml encoding="utf-8" ?>' . $html_string);
		$imgs = $doc->getElementsByTagName('img');
		if ($imgs->length) {
			foreach ($imgs as $item) {
				if ($item->getAttribute('src') != '') {
					$item->setAttribute('src', $this->create_absolute_url($item->getAttribute('src'), $base_url, $html_base_url));
				}
				if( $toprank && !empty($title) ) {
					if($item->hasAttribute('alt')) {
						if ($item->getAttribute('alt') == '') {
							$item->setAttribute('alt', $title);
						}
					} else {
						$item->setAttribute('alt', $title);
					}
				}
			}
		}		
		
		$a = $doc->getElementsByTagName('a');
		if ($a->length) {
			foreach ($a as $item) {
				if ($item->getAttribute('href') != '') {
					$item->setAttribute('href', $this->create_absolute_url($item->getAttribute('href'), $base_url, $html_base_url));
				}
			}
		}
		
		return $this->save_html_clean($doc);
	}	
	
	public function save_html_clean($domdocument) {
		$mock = new DOMDocument();
		$body = $domdocument->getElementsByTagName('body')->item(0);
		foreach ($body->childNodes as $child) {
			$mock->appendChild($mock->importNode($child, true));
		}
		return html_entity_decode($mock->saveHTML(), ENT_COMPAT, "UTF-8");
	}

	public function create_absolute_url($rel, $base, $html_base) {
		$rel = trim($rel);
		$base = strtolower(trim($base));
		if (substr($rel, 0, 11) == 'data:image/') {
			return $rel;
		}
		
		if (!empty($html_base)) {
			$base = $html_base;
		}
		
		return str_replace(" ", "%20", WP_Http::make_absolute_url($rel, $base));
	}	
}