<?php
// اتصال به دیتابیس
$servername = "localhost";
$username = "cloudapi_ali";
$password = "t[pynGRChGng";
$dbname = "cloudapi_ali";

// مپینگ ستون‌ها
$column_mapping = [
    'بخش مصرف' => 'بخش_مصرف',
    'گره کاربرد' => 'گره_کاربرد',
    'کاربرد' => 'کاربرد',
    'عنوان کاربرد کاربر' => 'عنوان_کاربرد_کاربر',
    'متولی اول' => 'متولی_اول',
    'نام متقاضی' => 'نام_متقاضی',
    'کدملی/ شناسه ملی' => 'کدملی_شناسه_ملی',
    'تلفن همراه' => 'تلفن_همراه',
    'آدرس' => 'آدرس',
    'کد فروش' => 'کد_فروش',
    'استان' => 'استان',
    'شهرستان' => 'شهرستان',
    'شناسه یکتای کاربرد' => 'شناسه_یکتای_کاربرد',
     'شماره درخواست' => 'شماره_درخواست',
    'فراوده' => 'فراوده',
    'نوع تحویل سوخت' => 'نوع_تحویل_سوخت',
    'مقدار تایید شده توسط پخش' => 'مقدار_تایید_شده_توسط_پخش',
    'مقدار تایید شده توسط متولی اول' => 'مقدار_تایید_شده_توسط_متولی_اول',
    'نام فروشندگی انتخاب شده در درخواست' => 'نام_فروشندگی_انتخاب_شده_در_درخواست',
    'کد فروشندگی انتخاب شده در درخواست' => 'کد_فروشندگی_انتخاب_شده_در_درخواست',
    'تاریخ تایید درخواست توسط پخش' => 'تاریخ_تایید_درخواست_توسط_پخش',
    'نوع درخواست' => 'نوع_درخواست'
];

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $conn->exec("SET NAMES utf8");
    
    // اطلاعات کلی جدول
    $table_info = $conn->query("SELECT COUNT(*) as total_rows FROM fuel_requests")->fetch();
    $total_rows = $table_info['total_rows'];
    
    echo "<!DOCTYPE html>
    <html dir='rtl'>
    <head>
        <meta charset='UTF-8'>
        <title>تحلیل دیتابیس درخواست‌های سوخت</title>
        <style>
            body { font-family: Tahoma, sans-serif; margin: 20px; background-color: #f5f5f5; }
            .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
            h3 { color: #2c3e50; text-align: center; margin-bottom: 20px; }
            table { width: 100%; border-collapse: collapse; margin: 20px 0; }
            th, td { border: 1px solid #ddd; padding: 12px; text-align: right; }
            th { background-color: #3498db; color: white; font-weight: bold; }
            tr:nth-child(even) { background-color: #f2f2f2; }
            tr:hover { background-color: #e8f4fc; }
            .unique-count { font-weight: bold; color: #e74c3c; }
            .column-selector { margin: 20px 0; padding: 15px; background: #ecf0f1; border-radius: 5px; }
            .stats { background: #2ecc71; color: white; padding: 10px; border-radius: 5px; margin: 10px 0; }
        </style>
    </head>
    <body>
        <div class='container'>
            <h3>📊 تحلیل جامع دیتابیس درخواست‌های سوخت</h3>
            
            <div class='stats'>
                <strong>تعداد کل رکوردها: " . number_format($total_rows) . " مورد</strong>
            </div>";
    
    // فرم انتخاب ستون
    echo "<div class='column-selector'>
            <h4>🔍 انتخاب ستون برای تحلیل دقیق</h4>
            <form method='post'>
                <select name='selected_column' style='padding: 8px; width: 300px;'>
                    <option value=''>-- انتخاب ستون --</option>";
    
    foreach ($column_mapping as $persian_name => $db_column) {
        echo "<option value='$db_column'>$persian_name</option>";
    }
    
    echo "</select>
                <input type='submit' value='نمایش جزئیات' style='padding: 8px 15px; background: #3498db; color: white; border: none; border-radius: 4px; cursor: pointer;'>
            </form>
          </div>";
    
    // نمایش جزئیات ستون انتخاب شده
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['selected_column']) && !empty($_POST['selected_column'])) {
        $selected_db_column = $_POST['selected_column'];
        
        // پیدا کردن نام فارسی ستون
        $selected_persian_name = array_search($selected_db_column, $column_mapping);
        
        if ($selected_persian_name) {
            // تعداد مقادیر یکتا
            $unique_stmt = $conn->prepare("SELECT COUNT(DISTINCT `$selected_db_column`) FROM fuel_requests");
            $unique_stmt->execute();
            $unique_count = $unique_stmt->fetchColumn();
            
            // تمام مقادیر یکتا با تعداد تکرار
            $values_stmt = $conn->prepare("
                SELECT `$selected_db_column`, COUNT(*) as count 
                FROM fuel_requests 
                GROUP BY `$selected_db_column` 
                ORDER BY count DESC
            ");
            $values_stmt->execute();
            $all_values = $values_stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo "<h4>📈 نتایج تحلیل ستون: <span style='color: #e74c3c;'>$selected_persian_name</span></h4>";
            echo "<p><strong>تعداد مقادیر یکتا:</strong> <span class='unique-count'>" . number_format($unique_count) . "</span></p>";
            echo "<p><strong>درصد یکتایی:</strong> " . ($total_rows > 0 ? round(($unique_count / $total_rows) * 100, 2) : 0) . "%</p>";
            
            echo "<table>
                    <tr>
                        <th>ردیف</th>
                        <th>مقدار</th>
                        <th>تعداد تکرار</th>
                        <th>درصد</th>
                    </tr>";
            
            $counter = 1;
            foreach ($all_values as $value) {
                $display_value = $value[$selected_db_column] ?? 'NULL';
                $count = $value['count'];
                $percentage = $total_rows > 0 ? round(($count / $total_rows) * 100, 2) : 0;
                
                echo "<tr>
                        <td>" . $counter++ . "</td>
                        <td>" . htmlspecialchars($display_value) . "</td>
                        <td>" . number_format($count) . "</td>
                        <td>" . $percentage . "%</td>
                      </tr>";
            }
            
            echo "</table>";
        }
    }
    
    // نمایش خلاصه تمام ستون‌ها
    echo "<h4>📋 خلاصه وضعیت تمام ستون‌ها</h4>
          <table>
            <tr>
                <th>نام ستون (فارسی)</th>
                <th>نام ستون (دیتابیس)</th>
                <th>تعداد مقادیر یکتا</th>
                <th>درصد یکتایی</th>
                <th>نمونه مقادیر</th>
            </tr>";
    
    foreach ($column_mapping as $persian_name => $db_column) {
        // تعداد مقادیر یکتا
        $unique_stmt = $conn->prepare("SELECT COUNT(DISTINCT `$db_column`) FROM fuel_requests");
        $unique_stmt->execute();
        $unique_count = $unique_stmt->fetchColumn();
        
        // درصد یکتا
        $unique_percentage = $total_rows > 0 ? round(($unique_count / $total_rows) * 100, 2) : 0;
        
        // نمونه مقادیر
        $sample_stmt = $conn->prepare("SELECT DISTINCT `$db_column` FROM fuel_requests WHERE `$db_column` IS NOT NULL AND `$db_column` != '' LIMIT 3");
        $sample_stmt->execute();
        $sample_values = $sample_stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $sample_display = array_map(function($value) {
            $display = $value ?? 'NULL';
            return strlen($display) > 30 ? substr($display, 0, 30) . '...' : $display;
        }, $sample_values);
        
        $percentage_color = $unique_percentage == 100 ? 'color: #27ae60;' : ($unique_percentage > 80 ? 'color: #f39c12;' : 'color: #e74c3c;');
        
        echo "<tr>
                <td><strong>$persian_name</strong></td>
                <td><code>$db_column</code></td>
                <td style='$percentage_color'><strong>" . number_format($unique_count) . "</strong></td>
                <td style='$percentage_color'><strong>$unique_percentage%</strong></td>
                <td>" . (!empty($sample_display) ? implode("<br>", array_map('htmlspecialchars', $sample_display)) : 'بدون داده') . "</td>
              </tr>";
    }
    
    echo "</table>
        </div>
    </body>
    </html>";
    
} catch(PDOException $e) {
    echo "<div style='color: red; padding: 20px; background: #ffe6e6; border: 1px solid red; border-radius: 5px;'>
            <strong>خطا در اتصال به دیتابیس:</strong> " . $e->getMessage() . "
          </div>";
}
$conn = null;
?>