<?php
/**
 * Source file was changed on the Tue Sep 6 16:23:37 2022 +0200
 */

namespace WP_Rocket\Engine\CriticalPath;

use Exception;
use WP_Rocket\Event_Management\Subscriber_Interface;

/**
 * Subscriber for the ApiClient
 *
 * @note CL
 */
class ApiClientSubscriber implements Subscriber_Interface {
	/**
	 * RocketCPCSS API Client instance.
	 *
	 * @var APIClient
	 */
	private $api_client;

	/**
	 * CCSSOptionsManager instance
	 *
	 * @var CCSSAWPOptionsManager
	 */
	private $ccss_options;

	/**
	 * Constructor
	 *
	 * @param APIClient             $api_client   RocketCPCSS API Client instance.
	 * @param CCSSAWPOptionsManager $ccss_options CCSSOptionsManager instance.
	 */
	public function __construct( APIClient $api_client, CCSSAWPOptionsManager $ccss_options ) {
		$this->api_client   = $api_client;
		$this->ccss_options = $ccss_options;
	}

	/**
	 * {@inheritdoc}
	 */
	public static function get_subscribed_events() {
		return [
			'rocket_cpcss_accelerate_wp_cli_enable'  => [ 'cli_cpcss_enable', 10, 1 ],
			'rocket_cpcss_accelerate_wp_cli_disable' => 'cli_cpcss_disable',
			'rocket_input_sanitize'                  => [ 'sanitize_options', 14, 2 ],
		];
	}

	/**
	 * Enable the CPCSS
	 *
	 * @param string $unique_id Unique CLN user id.
	 *
	 * @return void
	 * @throws Exception Data error.
	 */
	public function cli_cpcss_enable( $unique_id ) {
		$this->api_client->enable( $unique_id );
	}

	/**
	 * Disable the CPCSS
	 *
	 * @return bool
	 */
	public function cli_cpcss_disable() {
		$this->api_client->disable();

		return true;
	}

	/**
	 * Sanitizes options
	 *
	 * @param array         $input    Array of values submitted from the form.
	 * @param AdminSettings $settings Settings class instance.
	 *
	 * @note CL
	 * @return array
	 */
	public function sanitize_options( $input, $settings ) : array {
		$awp_unique_id = $this->ccss_options->get_awp_unique_id();

		$input['ccss_awp_unique_id'] = $awp_unique_id;

		return $input;
	}
}
