<?php if (get_theme_mod('cafe_coffee_charm_our_products_show_hide_section', false)) { ?>
    <section id="product_cat_slider" class="my-5 mx-md-0 mx-3">
        <div class="container">
        <?php if ($cafe_coffee_charm_category_small_heading = get_theme_mod('cafe_coffee_charm_category_small_heading')) { ?>
            <p class="text-center short_head mb-2"><?php echo esc_html($cafe_coffee_charm_category_small_heading); ?></p>
        <?php } ?>
        <?php if ($cafe_coffee_charm_product_heading = get_theme_mod('cafe_coffee_charm_product_heading')) { ?>
            <h2 class="text-center mb-4 text-capitalize"><?php echo esc_html($cafe_coffee_charm_product_heading); ?></h2>
        <?php } ?>

        <?php if (class_exists('woocommerce')) : ?>
            <div id="product-carousel" class="owl-carousel owl-theme">
                <?php
                // Query Products by Selected Category
                $cafe_coffee_charm_selected_category = get_theme_mod('cafe_coffee_charm_our_product_product_category','product_cat8');
                if ($cafe_coffee_charm_selected_category) {
                    $cafe_coffee_charm_args = array(
                        'post_type'      => 'product',
                        'posts_per_page' => 50,
                        'product_cat'    => $cafe_coffee_charm_selected_category,
                        'order'          => 'ASC'
                    );
                    $cafe_coffee_charm_loop = new WP_Query($cafe_coffee_charm_args);
                    if ($cafe_coffee_charm_loop->have_posts()) : 
                        while ($cafe_coffee_charm_loop->have_posts()) : $cafe_coffee_charm_loop->the_post();
                        global $product;
                ?>
                  <div class="item"> <!-- owl item -->
                    <div class="product-box">
                      <div class="product-image mb-2 position-relative">
                        <?php echo woocommerce_get_product_thumbnail(); ?>

                        <h3 class="my-0">
                          <a href="<?php the_permalink(); ?>">
                            <?php echo esc_html(get_the_title()); ?>
                          </a>
                        </h3>
                        <p class="my-2 product-price" style="color: <?php echo $product->is_on_sale() ? 'black' : 'gray'; ?>">
                          <?php echo $product->get_price_html(); ?>
                        </p>
                      </div>
                    </div>
                  </div>
                <?php
                    endwhile;
                    wp_reset_postdata();
                endif;
                }
                ?>
            </div>
        <?php endif; ?>
        </div>
    </section>
<?php } ?>
