<?php

defined('ABSPATH') || exit;

/**
 * session stat for current redirect URL after login from social.
 *
 * @since : 1.0
 */
session_start();

if(isset($_GET['XScurrentPage']) and strlen($_GET['XScurrentPage']) > 2) {
	$_SESSION['xs_social_login_ref_url'] = $_GET['XScurrentPage'];

	$_SESSION['xs_social']['login_ref_url'] = $_GET['XScurrentPage'];
}

//wordpress default redirect_to param
if(!empty($_GET['redirect_to'])) {

	$_SESSION['xs_social']['redirect_to'] = urldecode($_GET['redirect_to']);
}

/**
 * Variable Name: $currentURL
 * Variable Details: get Current URL from session data after login by social
 *
 * @since : 1.0
 */
$currentURL = isset($_SESSION['xs_social_login_ref_url']) ? $_SESSION['xs_social_login_ref_url'] : get_site_url();

/**
 * Wp Function: is_user_logged_in();
 * Function Details: check user login. If user is login after redirect current URL by $currentURL
 *
 * @since : 1.0
 */

if(is_user_logged_in()) {
	if(wp_redirect($currentURL)) {
		exit;
	}
}

/**
 * Variable Name : $xs_config
 * Variable Type : Array
 *
 * @since : 1.0
 */
$xs_config = [];

if(!empty($typeSocial)) {
	/**
	 * Variable Name : $provider_data
	 * Variable Type : Array
	 * @return : array() $provider_data .  Get array from socail provider data "xs_provider_data"
	 *
	 * @since : 1.0
	 */
	$provider_data = get_option('xs_provider_data');
	/**
	 * Variable Name : $callBackUrl
	 * Variable Type : String
	 * Variable Details : Create dynamic callback URL for all social services.
	 *
	 * @since : 1.0
	 */
	$callBackUrl = get_site_url() . '/wp-json/wslu-social-login/type/' . $typeSocial;
	/**
	 * Variable Name : $serviceType
	 * Variable Type : Array
	 * @return : array() xs_services_provider().  Get array from custom function page "admin-custom-function.php" - "xs_services_provider()"
	 *
	 * @since : 1.0
	 */
	$serviceType = xs_services_provider();

	/**
	 * check array key from $serviceType by social type . For Example: facebook
	 *
	 * @since : 1.0
	 */
	if(array_key_exists($typeSocial, $serviceType)) {
		$socialType = $serviceType[$typeSocial];
	}

	/**
	 * API configration for Facebook, Twitter, Linkedin, Dribble, Pinterest, Wordpress, Instagram, GitHub, Vkontakte and Reddit
	 *
	 * @since : 1.0
	 */

	/**
	 * Set callback URL in array "$xs_config" for configration API
	 *
	 * @since : 1.0
	 */
	$xs_config['callback'] = $callBackUrl;

	/**
	 * Create array for API Providers for all service using foreach by variable "$serviceType"
	 *
	 * @since : 1.0
	 */
	foreach($serviceType as $serviceKey => $serviceValue) :
		$idData = 'id';
		if($serviceKey == 'twitter') {
			$idData = 'key';
		}

		$xs_config['providers'][$serviceValue] = [
			'enabled' => true,
			'keys'    => [
				$idData  => isset($provider_data[$serviceKey]['id']) ? $provider_data[$serviceKey]['id'] : '',
				'secret' => isset($provider_data[$serviceKey]['secret']) ? $provider_data[$serviceKey]['secret'] : '',
			],
		];
	endforeach;
}


/**
 * Config API
 *
 * @since : 1.0
 */
$code = isset($_GET['code']) ? $_GET['code'] : '';

if(strlen($socialType) > 0) {

	try {
		$hybridauth = new Hybridauth\Hybridauth($xs_config);
		$adapter    = $hybridauth->authenticate($socialType);

		$isConnected = $adapter->isConnected();

		if($isConnected) :
			$getProfile = $adapter->getUserProfile();

			if(is_object($getProfile) && !empty($getProfile)) {

				/**
				 * Variable Name : $setting_data
				 * Variable Type : Array
				 * @return : array() $setting_data .  Get array from social global setting data "xs_global_setting_data"
				 *
				 * @since : 1.0
				 */
				$setting_data = get_option(\WP_Social\Keys::OK_GLOBAL_SETTINGS);

				/**
				 * Resolve it before resetting the session
				 */
				$final_redirect = resolve_redirect_url($_SESSION, $setting_data);


				/**
				 * Now cleaning the session
				 *
				 */
				xs_login_session_handaler();

				$nice_name = \WP_Social\App\Avatar::instance()->get_nice_name($getProfile, $socialType);
				$last_name = \WP_Social\App\Avatar::instance()->get_last_name($getProfile, $socialType);
				$user_name = \WP_Social\App\Avatar::instance()->get_username($getProfile, $socialType);
				$display_nm = \WP_Social\App\Avatar::instance()->get_display_name($getProfile, $socialType);
				$user_email = $getProfile->email;

				$insertData   = [];
				$insertData['first_name']    = $nice_name;
				$insertData['last_name']     = $last_name;
				$insertData['user_nicename'] = $nice_name;
				$insertData['user_email']    = $user_email;
				$insertData['display_name']  = $display_nm;


				//echo '<pre>'; var_dump($socialType, $getProfile, $insertData); die('died..6..!');

				/**
				 * Check if user exists with prepared username
				 *
				 * @since : 1.0
				 */
				$user_id = username_exists($user_name);

				if($user_id) {

					$user_nameD = xs_login_get_user_data($user_name, 'user_login');

					xs_user_login($user_nameD, $final_redirect);

					die('Most unlikely error occurred in your case.');

				}


				/**
				 * User could not found with username but
				 * User could be exists with email that is used in social account too
				 * In this case we are we will allow user to login without changing users actual password
				 * with this approach user can also login with his email and password
				 *
				 */
				$user_id = email_exists($user_email);

				if($user_id) {

					$user_nameD = xs_login_get_user_data_email($user_email, 'user_login');

					xs_user_login($user_nameD, $final_redirect);

					die('Most unlikely error occurred in your case.');
				}

				/**
				 * Grabbing the default role settings for new user
				 * Though it is working with wp_insert_user still adding this as per Ataur bhai
				 *
				 */
				$default_role = get_option('default_role', '');

				/**
				 * User does not exists with prepared username or
				 * email from social site in our system
				 *
				 * Save the image from social site a attachment
				 * lets make a random password
				 * now create a new user
				 *
				 */
				$password                 = wp_generate_password();
				$insertData['user_login'] = $user_name;
				$insertData['user_pass']  = $password;
				$insertData['role']       = $default_role;

				//save the profile image
				$avatar_url = \WP_Social\App\Avatar::instance()->get_avatar_url($getProfile, $socialType);
				$attach = save_image_from_url_as_attachment($avatar_url);

				//$checkUser = xs_login_create_user($insertData);
				$checkUser = xs_social_create_user($insertData);

				if($checkUser > 0) {
					/**
					 * User created successful
					 * Update user meta
					 * Notify admin a new user has been created
					 * Notify user? [AR: a customer asked!]
					 *
					 */

					if(empty($attach['error'])) {

						update_user_meta($checkUser, 'xs_social_profile_image', $attach['url']);
						update_user_meta($checkUser, 'xs_social_profile_image_id', $attach['attachment_id']);
					} else {
						update_user_meta($checkUser, 'xs_social_profile_image', '');
						update_user_meta($checkUser, 'xs_social_profile_image_error_log', $socialType.'::'.$attach['error']);
					}


					/**
					 * As we have created the user with a random password and they are registering with social credential
					 * so there is no use of change of password
					 */
					update_user_meta($checkUser, 'xs_password_changed', 'yes');

					notify_new_user_to_user($insertData);
					notify_new_user_to_admin($checkUser, $socialType);

					xs_user_login($user_name, $final_redirect);

					die('Most most unlikely error occurred in your case. user registration done but login failed!!');
				}

				die('New user creation failed!');

			} else {
				die('System Error for Callback!');
			}

		endif;

		$adapter->disconnect();

	} catch(\Exception $e) {
		echo 'Oops, we ran into an issue! ' . $e->getMessage();
	}
}


/**
 * Function Name : xs_login_create_user();
 * Function Details : create new user from socail login and check enable wp new create new users.
 *
 * @params : array() $userdata. For user information
 *
 * @return : int() if success then user id else 0
 *
 * @since : 1.0
 */

function xs_login_create_user($userdata) {

	// todo - permission checking removed for registering user : consult with CTO

	$user_id = wp_insert_user($userdata);

	if(!is_wp_error($user_id)) {

		update_user_meta($user_id, 'xs_password_changed', 'no');

		return $user_id;
	}

	return 0;
}


add_action('init', 'xs_login_create_user');

/**
 * Function Name : xs_login_get_user_data();
 * Function Details : Get user information when user already exists into database
 *
 * @params : String() $loginName. User login name
 *
 * @return : String() User information by set filed from database table.
 *
 * @since : 1.0
 */
function xs_login_get_user_data($loginName, $getFiled = 'user_login') {
	$users = get_user_by('login', $loginName);
	if(empty($users)) {
		return '';
	}

	return $users->data->$getFiled;
}


add_action('init', 'xs_login_get_user_data');

/**
 * Function Name : xs_login_get_user_data_email();
 * Function Details : Get user information when email already exists into database
 *
 * @params : String() $email. User login name
 *
 * @return : String() User information by set filed from database table.
 *
 * @since : 1.0
 */
function xs_login_get_user_data_email($email, $getFiled = 'user_login') {
	$users = get_user_by('email', $email);
	if(empty($users)) {
		return '';
	}

	return $users->data->$getFiled;
}


add_action('init', 'xs_login_get_user_data');
/**
 * Function Name : xs_user_login();
 * Function Details : User login function by wp_signon();
 *
 * @params : String() $user_name. User login name
 * @params : String() $password. User password
 *
 * @return : True | False
 *
 * @since : 1.0
 */
function xs_user_login($user_name, $redirect_to = '') {
	if(strlen($user_name) == 0) {
		die('User name is empty!');
	}

	$username = $user_name;
	$user     = get_user_by('login', $username);


	if(!is_wp_error($user)) {
		wp_clear_auth_cookie();
		wp_set_current_user($user->ID);
		wp_set_auth_cookie($user->ID);

		$redirect_to = empty($redirect_to) ? user_admin_url() : $redirect_to;
		wp_safe_redirect($redirect_to);
		exit();
	}
}


add_action('init', 'xs_user_login');


/**
 * Get file extension fro a image that is rendering from a php url
 *
 * @since 1.0.0
 *
 * @param $url
 *
 * @return array|string
 */
function get_file_ext_from_url($url) {

	$extension = '';
	$headers   = wp_get_http_headers($url);
	$mime_type = $headers['content-type'];

	foreach(wp_get_mime_types() as $ext => $mime) {
		if($mime == $mime_type) {

			$extension = explode('|', $ext);

			return $extension[0];
		}
	}

	return $extension;
}


/**
 * Save a image php url as a attachment of post
 *
 * @since 1.0.0
 *
 * @param $url
 * @param string $unique_name - name with extension
 * @param int $post_id - default 0
 *
 * @return array
 */
function save_image_from_url_as_attachment($url, $unique_name = '', $post_id = 0) {

	require_once(ABSPATH . "wp-admin" . '/includes/image.php');
	require_once(ABSPATH . "wp-admin" . '/includes/file.php');
	require_once(ABSPATH . "wp-admin" . '/includes/media.php');

	$ext = get_file_ext_from_url($url);
	$tmp = download_url($url);

	$name = empty($unique_name) ? '__tmp_' . time() . '.' . $ext : $unique_name;

	$file_array = array(
		'name'     => $name,
		'tmp_name' => $tmp,
	);


	/**
	 * Check for download errors
	 * if there are error unlink the temp file name
	 */
	if(is_wp_error($tmp)) {
		@unlink($file_array['tmp_name']);

		return [
			'error' => $tmp->get_error_message(),
		];
	}

	/**
	 * now we can actually use media_handle_sideload
	 * we pass it the file array of the file to handle
	 * and the post id of the post to attach it to
	 * $post_id can be set to '0' to not attach it to any particular post
	 */
	$id = media_handle_sideload($file_array, $post_id);

	/**
	 * We don't want to pass something to $id
	 * if there were upload errors.
	 * So this checks for errors
	 */
	if(is_wp_error($id)) {
		@unlink($file_array['tmp_name']);

		return [
			'error' => $id->get_error_message(),
		];
	}

	/**
	 * No we can get the url of the sideloaded file
	 * $value now contains the file url in WordPress
	 * $id is the attachment id
	 */
	$value = wp_get_attachment_url($id);


	return [
		'url'           => $value,
		'attachment_id' => $id,
	];
}


function xs_login_session_handaler() {

	session_unset();

	// do we ever need the below?
	if(isset($_SESSION['xs_social_login_ref_url'])) {
		unset($_SESSION['xs_social_login_ref_url']);
	}
}


/**
 *
 * @since 1.3.7
 *
 * @param $user_info
 *
 * @return int
 */
function xs_social_create_user($user_info) {

	/*
	 * todo - ask Ataur bhai - do we allow insert user without permission with social? it make sense to do so
	 *
	 */
	$getPermissionRegisterWP = get_option('users_can_register', 0);

	if($getPermissionRegisterWP == 0) {

		// return 0;
	}

	$user_id = wp_insert_user($user_info);

	if(is_wp_error($user_id)) {

		return 0;
	}


	return $user_id;
}


/**
 * Checking the parameter and settings to find the correct redirect url
 *
 * @since 1.3.8
 *
 * @param $session
 * @param $setting
 *
 * @return string
 */
function resolve_redirect_url($session, $setting) {

	/**
	 * First priority to wordpress default redirect_to param
	 * Second priority to custom login settings url
	 * Third priority to XScurrentPage param [AR : not sure where it is used though!]
	 * And lastly site home page
	 *
	 */

	if(!empty($session['xs_social']['redirect_to'])) {

		$final_redirect = $session['xs_social']['redirect_to'];

	} elseif(!empty($setting['custom_login_url']['enable']) && !empty($setting['custom_login_url']['data'])) {

		$final_redirect = $setting['custom_login_url']['data'];

	} elseif(!empty($session['xs_social']['login_ref_url'])) {

		$final_redirect = $session['xs_social']['login_ref_url'];

	} else {

		$final_redirect = user_admin_url();
	}

	return $final_redirect;
}


/**
 *
 * @since 1.3.8
 *
 */
function clear_social_session_data() {

	if(!empty($_SESSION['xs_social'])) {

		unset($_SESSION['xs_social']);
	}
}


/**
 *
 * @since 1.3.7
 *
 * @param $user_id
 *
 * @return mixed
 */
function notify_new_user_to_admin($user_id, $social_type) {

	wp_new_user_notification($user_id, null, 'both');

	return true;
}


/**
 *
 * @since 1.3.7
 *
 *
 * @param array $info_array
 *
 * @return bool
 */
function notify_new_user_to_user($info_array = []) {

	/*
	 * todo - complete it after discussion
	 */

	return true;
}

