<?php

namespace WP_Social\App;


use WP_Social\Traits\Singleton;

class Avatar {

	use Singleton;

	public function init() {

		add_filter('get_avatar', [$this, 'xs_social_get_avatar'], 10, 5 );
	}


	public function xs_social_get_avatar( $avatar = '', $id_or_email, $size = 96, $default = '', $alt = '' ) {

		if(is_numeric($id_or_email)) {

			$pic_url = get_user_meta($id_or_email, 'xs_social_profile_image', true);

			if(!empty($pic_url)) {

				return '<img alt="'.$alt.'" src="'.$pic_url.'" class="avatar avatar-'.$size.' photo" height="'.$size.'" width="'.$size.'" />';
			}
		}

		return $avatar;
	}


	/**
	 *
	 * @since 1.3.8
	 *
	 * @param $profile
	 * @param $type
	 *
	 * @return string
	 */
	public function get_nice_name($profile, $type) {

		switch($type) {

			case 'Twitter':
			case 'twitter': #fall through
			case 'Facebook':
			case 'facebook': #fall through
			case 'LinkedIn':
			case 'linkedIn':
			case 'Google':
			case 'google':

				$ret = $profile->firstName;
				break;

			case 'GitHub':
			case 'gitHub':

			$ret = empty($profile->firstName) ? ($this->get_display_name($profile, $type)) : $profile->firstName;
			break;

			default:

				$ret = empty($profile->firstName) ? 'Nice name' : $profile->firstName;
		}

		return $ret;
	}


	/**
	 *
	 * @since 1.3.8
	 *
	 * @param $profile
	 * @param $type
	 *
	 * @return string
	 */
	public function get_last_name($profile, $type) {

		switch($type) {

			case 'Twitter':
			case 'twitter': #fall through
			case 'Facebook':
			case 'facebook': #fall through
			case 'LinkedIn':
			case 'linkedIn': #fall through
			case 'Google':
			case 'google': #fall through
			case 'GitHub':
			case 'gitHub':

				$ret = empty($profile->lastName) ? '' : $profile->lastName;
				break;

			default:

				$ret = empty($profile->lastName) ? '' : $profile->lastName;
		}

		return $ret;
	}


	/**
	 *
	 * @since 1.3.8
	 *
	 * @param $profile
	 * @param $type
	 *
	 * @return string
	 */
	public function get_display_name($profile, $type) {

		switch($type) {

			case 'Twitter':
			case 'twitter': #fall through
			case 'Facebook':
			case 'facebook': #fall through
			case 'LinkedIn':
			case 'linkedIn': #fall through
			case 'Google':
			case 'google': #fall through
			case 'GitHub':
			case 'gitHub':

				$ret = $profile->displayName;
				break;

			default:

				$ret = empty($profile->displayName) ? $this->get_nice_name($profile, $type) : $profile->displayName;
		}

		return $ret;
	}



	/**
	 *
	 * @since 1.3.8
	 *
	 * @param $profile
	 * @param $type
	 *
	 * @return string
	 */
	public function get_username($profile, $type) {

		switch($type) {

			case 'Twitter':
			case 'twitter':

				$ret = 'twt' . $profile->identifier;
				break;

			case 'Facebook':
			case 'facebook':

				$ret = 'fb' . $profile->identifier;
				break;

			case 'LinkedIn':
			case 'linkedIn':

				$ret = 'Ln' . $profile->identifier;
				break;

			case 'Google':
			case 'google':

				$ret = 'G' . $profile->identifier;
				break;

			case 'GitHub':
			case 'gitHub':

				$ret = 'Gt' . $profile->identifier;
				break;

			default:

				$ret = empty($profile->identifier) ? strtolower($type) . '_' . $profile->email : strtolower($type) . '_' . $profile->identifier;
		}

		return $ret;
	}


	/**
	 *
	 * @since 1.3.8
	 *
	 * @param $profile
	 * @param $type
	 *
	 * @return mixed
	 */
	public function get_avatar_url($profile, $type) {

		switch($type) {

			case 'Twitter':
			case 'twitter': #fall through
			case 'Facebook':
			case 'facebook': #fall through
			case 'LinkedIn':
			case 'linkedIn': #fall through
			case 'Google':
			case 'google': #fall through
			case 'GitHub':
			case 'gitHub':

				$ret = $profile->photoURL;
				break;

			default:

				$ret = $profile->photoURL; // todo - later we will put the mystry man url from wordpress
		}

		return $ret;
	}
}