<div class="blog-item">
    <?php
    if (has_post_thumbnail()) { ?>
        <a class="entry-media" href="<?php echo get_the_permalink(); ?>">
            <?php the_post_thumbnail('medium'); ?>
        </a>
        <?php
    }
    ?>
    <div class="entry-content">
        <h3 class="card-title">
            <a href="<?php echo get_the_permalink(); ?>">
                <?php echo get_the_title(); ?>
            </a>
        </h3>
        <?php
        $trimexcerpt = get_the_excerpt();
        $shortexcerpt = mb_strimwidth($trimexcerpt, 0, $num_words = 70, ' ...');
        ?>
        <p><?php echo $shortexcerpt; ?></p>

        <div class="blog-card-footer d-flex align-items-center justify-content-between">
            <span class="post-date">
                <i class="icon-calendar"></i>
                <?php echo get_the_date(' m F Y'); ?>
            </span>
            <ul class="d-flex blog-card-categories">
                <?php
                $args_cat = array(
                    'number' => 2,
                    'orderby' => 'count',
                    'order' => 'DESC',
                    'title_li' => '',
                );
                wp_list_categories($args_cat );
                ?>
            </ul>
        </div>

    </div>
</div>
