<?php

/**
 * Class Name: wp_bootstrap_navwalker
 * GitHub URI: https://github.com/twittem/wp-bootstrap-navwalker
 * Description: A custom WordPress nav walker class to implement the Bootstrap 3 navigation style in a custom theme using the WordPress built in menu manager.
 * Version: 2.0.4
 * Author: Edward McIntyre - @twittem
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 */

class wp_bootstrap_navwalker extends Walker_Nav_Menu {

    // Start level (ul)
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"sub-menu depth-{$depth}\">\n";
        if($depth==1) {
            $output .= "\n$indent<li class=\"menu-item-right\">\n";
            $output .= "\n$indent<ul class=\"sub-menu-right\">\n";

        }
    }

    // Start each <li>
    public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        $icon = get_post_meta($item->ID, '_menu_item_icon', true);
        $image = get_post_meta($item->ID, '_menu_item_image', true);
        $mega_title = get_post_meta($item->ID, '_menu_item_desc', true);

        $classes = implode(' ', $item->classes);
        $title = $item->title;
        $url = $item->url;

        $output .= "<li class=\"menu-item $classes\">";
        $output .= "<a href=\"{$url}\">";

        if (($depth == 0 || $depth == 1) && $icon) {
            $output .= "<span class=\"menu-icon\"><img src=\"{$icon}\" alt=\"icon\" /></span>";
        }

        $output .= "{$title}</a>";

        if ($depth == 2 && ($image || $item->description || $mega_title)) {
            $output .= "<div class=\"mega-menu-content\">";
            if ($image) {
                $output .= "<div class=\"menu-image mb-4\"><img src=\"{$image}\" alt=\"{$title}\" /></div>";
            }
            if ($mega_title) {
                $output .= "<h3 class='menu-title'>{$mega_title}</h3>";
            }
            if ($item->description) {
                $output .= "<div class=\"menu-desc\">{$item->description}</div>";
            }
            $output .= "</div>";
        }

        // close will be handled in end_el()
    }

    public function end_el( &$output, $item, $depth = 0, $args = array() ) {
        $output .= "</li>\n";
    }

    public function end_lvl( &$output, $depth = 0, $args = array() ) {
        if($depth==1) {
            $output .= "</ul>\n";
            $output .= "</li>\n";
        }
        $output .= "</ul>\n";
    }
}
?>
