<?php
// After setup theme hook adds WC support
function mytheme_add_woocommerce_support()
{
    add_theme_support('woocommerce'); // <<<< here
}

// add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support('wc-product-gallery-lightbox');
add_theme_support('wc-product-gallery-slider');
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');
//Change the order of filter in product archive
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close' , 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
//remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
add_action('template_redirect', 'remove_sidebar_shop');

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );


function remove_sidebar_shop(){
    if (is_product()) {
        remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar');
    }
}

add_filter('woocommerce_enqueue_styles', '__return_empty_array');
// Remove Marketing Hub menu item
add_filter('woocommerce_marketing_menu_items', '__return_empty_array');

// Sidebar
function sidebar_woocommerce_filter()
{
    register_sidebar(array(
        'name' => __('سایدبار فروشگاه', 'textdomain'),
        'id' => 'sidebar-woocommerce-filter',
        'before_widget' => '<div id="%1$s" class="widget widget-product %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>'
    ));
}

add_action('widgets_init', 'sidebar_woocommerce_filter');

add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 20);
function new_loop_shop_per_page($cols)
{
    $cols = 9;
    return $cols;
}

add_filter('woocommerce_structured_data_product', 'structured_data_product_nulled', 10, 2);
function structured_data_product_nulled($markup, $product)
{
    if (is_product()) {
        $markup = '';
    }
    return $markup;
}

add_action('add_meta_boxes', 'remove_product_description_editor', 99);
function remove_product_description_editor() {
    remove_post_type_support('product', 'editor');
}

add_filter('woocommerce_product_data_tabs', 'remove_shipping_product_data_tab');
function remove_shipping_product_data_tab($tabs) {
    unset($tabs['shipping']);
    unset($tabs['advanced']);
    unset($tabs['inventory']);
    return $tabs;
}

add_filter('woocommerce_admin_features', 'disable_woocommerce_analytics');

function disable_woocommerce_analytics($features) {
    return array_diff($features, ['analytics']);
}

add_action('woocommerce_product_query', 'filter_products_by_stock_status');
function filter_products_by_stock_status($q) {
    if ( isset($_GET['stock_status']) && $_GET['stock_status'] === 'instock' ) {
        $meta_query = $q->get('meta_query');
        $meta_query[] = array(
            'key'     => '_stock_status',
            'value'   => 'instock',
            'compare' => '='
        );
        $q->set('meta_query', $meta_query);
    }
}

function my_woocommerce_catalog_orderby( $orderby ) {
    $orderby['popularity'] = __('محبوب ترین', 'tiyara');
    $orderby['rating'] = __('پرامتیازترین', 'tiyara');
    $orderby['date'] = __('جدیدترین', 'tiyara');
    $orderby['price'] = __('گرانترین', 'tiyara');
    $orderby['price-desc'] = __('ارزانترین', 'tiyara');
    return $orderby;
}
add_filter( 'woocommerce_catalog_orderby', 'my_woocommerce_catalog_orderby', 20 );

function tiyara_sale_flash_percentage( $product_html, $post, $product ) {
    if ( $product->is_on_sale() ) {
        $regular_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();

        if ( $regular_price && $sale_price ) {
            $discount_percentage = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
            $product_html = '<span class="onsale">' . $discount_percentage . '%</span>';
        }
    }
    return $product_html;
}
add_filter( 'woocommerce_sale_flash', 'tiyara_sale_flash_percentage', 10, 3 );





