<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
global $wp_query;
$cat_id = $wp_query->get_queried_object_id();
?>
<div class="page-wrap archive-blog">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-md-8 col-lg-9">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo single_cat_title(); ?>
                </h1>
                <?php if (category_description() != '') { ?>
                    <div class="page-desc">
                        <?php echo category_description(); ?>
                    </div>
                <?php } ?>
                <div class="row">
                    <?php
                    $args = array(
                        'post_type' => 'post',
                        'paged' => $paged,
                        'post_status ' => 'publish',
                        'cat' => $cat_id,
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                        $i = 0.25;
                        while ($posts->have_posts()) : $posts->the_post();
                            echo '<div class="col-12 col-sm-6 col-lg-4 blog-item-wrapper wow fadeInUp" data-wow-delay="0.25s">';
                            get_template_part('templates/card/blog', 'card');
                            echo '</div>';
                            $i += 0.25; endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
                <!-- Pagination -->
                <div class="pagination pagination_wrap">
                    <?php pagination_bar($posts); ?>
                </div>
            </div>
            <aside class="col-12 col-md-4 col-lg-3 order-md-first">
                <div class="sidebar-inner">
                    <?php get_sidebar(); ?>
                </div>
            </aside>
        </div>
    </div>
</div>

<?php get_footer(); ?>

