<?php $__env->startComponent('user::frontend.partials.content'); ?>
    <div class="row">
        <div class="col-md-4 mb-3 mt-3 mt-lg-0">
            <div class="single-product">
                <h3>
                    <i class="fi fi-rr-shopping-bag-add align-middle line-height-1"></i>
                    تعداد کل سفارش ها
                </h3>
                <span class="subtitle"><?php echo e(auth()->user()->orders->where('status' , 'paid')->count()); ?>

                عدد
                </span>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="single-product">
                <h3>
                    <i class="fi fi-rr-truck-moving align-middle line-height-1"></i>
                    سفارش های ارسال شده
                </h3>
                <span class="subtitle"><?php echo e(auth()->user()->orders->where('status' , 'posted')->count()); ?>

                عدد
                </span>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="single-product">
                <h3>
                    <i class="fi fi-rr-clock align-middle line-height-1"></i>
                    سفارش های در حال پردازش
                </h3>
                <span class="subtitle"><?php echo e(auth()->user()->orders->where('status' , 'preparation')->count()); ?>

                عدد
                </span>
            </div>
        </div>
    </div>
    <div class="mt-4 single-product table-responsive">
        <h3>آخرین سفارش ها</h3>
        <table class="table table-hover">
            <tr>
                <th>کد سفارش</th>
                <th>مبلغ سفارش</th>
                <th>وضعیت سفارش</th>
                <th>نحوه ارسال</th>
                <th>عملیات</th>
            </tr>
            <?php if(auth()->user()->orders->count()): ?>

                <?php $__currentLoopData = auth()->user()->orders->sortDesc()->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>#<?php echo e($order->order_code); ?></td>
                        <td><?php echo e(number_format($order->price)); ?>

                        تومان
                        </td>
                        <td>
                            <?php switch($order->status):
                                case ('paid'): ?>
                                <span class="badge bg-success">پرداخت شده</span>
                                <?php break; ?>
                                <?php case ('unpaid'): ?>
                                <span class="badge bg-warning">پرداخت نشده</span>
                                <?php break; ?>
                                <?php case ('preparation'): ?>
                                <span class="badge bg-primary">در حال پردازش</span>
                                <?php break; ?>
                                <?php case ('canceled'): ?>
                                <span class="badge bg-danger">لغو شده</span>
                                <?php break; ?>
                                <?php case ('posted'): ?>
                                <span class="badge bg-success">ارسال شده</span>
                                <?php break; ?>
                                <?php case ('received'): ?>
                                <span class="badge bg-success">رسیده به مشتری</span>
                                <?php break; ?>
                            <?php endswitch; ?>
                        </td>
                        <td><?php echo e($order->shipping->label); ?></td>
                        <td>
                            <a href="<?php echo e(route('profile.order.show' , $order)); ?>" class="badge bg-info">
                                جزئیات
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="default-alert mb-3">
                    هنوز هیچ سفارشی ثبت نشده است
                </div>
            <?php endif; ?>
        </table>
    </div>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworld/core/Modules/User/Resources/views/frontend/partials/content/home.blade.php ENDPATH**/ ?>