<?php $__env->startComponent('frontend.layouts.components.page' , ['title' => $category->name]); ?>
    <?php $__env->startSection('head'); ?>
        <?php echo JsonLd::generate(); ?>

    <?php $__env->stopSection(); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="tm-breadcrumb-item"><?php echo e($category->name); ?></li>
    <?php $__env->endSlot(); ?>
    <section class="container mt-5 mb-5">
        <div class="shop">
            <div class="single-product  mb-3">
                <div class="row">
                    <div class="col-md-5">
                        <?php if($category->cat_image): ?>
                            <img src="<?php echo e(asset($category->cat_image)); ?>" alt="<?php echo e($category->name); ?>" class="br-1">
                        <?php endif; ?>
                    </div>
                    <div class="col-md-7">
                        <h1><?php echo e($category->name); ?></h1>
                        <?php echo $category->cat_desc; ?>

                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3">
                   <?php echo $__env->make('shop::frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-12 col-lg-9">
                    <?php if($category->products->count()): ?>
                    <?php echo $__env->make('shop::frontend.partials.content' , ['item' => $products], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <div class="single-product position-relative">
                            <!--Shop Products-->
                            <nav class="shop-nav">
                                <div class="shop-nav-left">
                                    <div class="shop-filter-btn show-in-mobile">
                                        <i class="bi bi-funnel"></i>
                                        فیلتر ها
                                    </div>
                                </div>
                                <div class="shop-nav-right">
                                    <div class="shop-nav-item">
                                        <form action="#" class="shop-sort">
                                            <label for="order">مرتب سازی</label>
                                            <select class="form-select shop-nav-select br-1" id="order">
                                                <option value="0">پیش فرض</option>
                                                <option value="most-selling">پرفروش ترین</option>
                                                <option value="cheap">ارزان ترین</option>
                                                <option value="expensive">گرانترین</option>
                                                <option value="new">جدیدترین</option>
                                            </select>
                                        </form>
                                    </div>
                                </div>
                            </nav>
                            <div class="row" id="filter-result">محصولی در دسته بندی "<?php echo e($category->name); ?>" وجود ندارد</div>

                            <span class="add-to-cart-loader cart-loader" style="display: none;">
                        <svg xmlns="http://www.w3.org/2000/svg" style="margin: auto;" width="80px" height="80px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                        <circle cx="50" cy="50" r="32" stroke-width="8" stroke="#ffa701" stroke-dasharray="50.26548245743669 50.26548245743669" fill="none" stroke-linecap="round">
                            <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" keyTimes="0;1" values="0 50 50;360 50 50"></animateTransform>
                        </circle>
                    </svg>
                    </span>
                        </div>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldc/core/Modules/Product/Resources/views/frontend/categories/content.blade.php ENDPATH**/ ?>