<?php $__env->startComponent('frontend.layouts.components.page' , ['title' => $post->title]); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="tm-breadcrumb-item">وبلاگ</li>
        <li class="tm-breadcrumb-item"><?php echo e($post->title); ?></li>
    <?php $__env->endSlot(); ?>
<?php $__env->startSection('head'); ?>
    <script type="application/ld+json">
        [{
        "@context": "https://schema.org/",
        "@type": "CreativeWorkSeason",
        "name": "<?php echo e($post->title); ?>",
        "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5",
        "ratingCount": "<?php echo e($post->rating_count); ?>",
        "bestRating": "5",
        "worstRating": "1"
        }}]

    </script>
<?php $__env->stopSection(); ?>
<section>
    <div class="container">
        <div class="row mt-5">
            <div class="col-md-9">

                <!--content-->
                <div class="mb-3">
                    <div class="container">
                        <div class="single-product">
                            <?php echo $post->body; ?>

                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">
                <div class="sticky-sidebar">
                    <img src="<?php echo e(asset($post->image)); ?>" alt="" class="br-1 card-shadow">
                    <div class="blog-sidebar-feed mt-4 br-1 single-product">
                        <div class="title-box">
                            <div class="title-wrapper">
                                <h3 class="title title-line">مقالات دیگر</h3>
                            </div>
                        </div>
                        <ul class="blog-feed">
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="feed-item">
                                    <div class="feed-image">
                                        <a href="<?php echo e(route('post.show' , $post)); ?>">
                                            <?php if($post->image): ?>
                                                <img src="<?php echo e(asset($post->image)); ?>" alt="">
                                            <?php else: ?>
                                                <img src="/images/other/no-image.jpg" alt="">
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                    <div class="feed-details">
                                        <a href="../blog/blog-details.html">
                                            <h3><?php echo e($post->title); ?></h3>
                                        </a>
                                        <p class="subtitle">
                                            تاریخ انتشار:
                                            <a href="#" class="post-date">
                                                <?php echo e(\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()); ?>

                                            </a>
                                        </p>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="<?php echo e(asset('/js/responsive-sidebar.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/comments.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldc/core/Modules/Post/Resources/views/frontend/show.blade.php ENDPATH**/ ?>