<?php $__env->startComponent('backend.layouts.components.main',[
    'title' => 'مدیریت کد های تخفیف', 'titleBar'=>true , 'button' => 'افزودن کد تخفیف' , 'route' => 'admin.discounts.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">کد های تخفیف</li>


    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست کد تخفیف ها</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                        <tr>
                            <th>آی‌دی تخفیف</th>
                            <th>کد تخفیف</th>
                            <th>میزان تخفیف (درصد)</th>
                            <th>مربوط به کاربر</th>
                            <th>مربوط به محصول</th>
                            <th>مربوط به دسته</th>
                            <th>مهلت استفاده</th>
                            <th>اقدامات</th>
                        </tr>

                        <?php $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($discount->id); ?></td>
                                <td><?php echo e($discount->code); ?></td>
                                <td><?php echo e($discount->percent); ?></td>
                                <td><?php echo e($discount->users->count() ? $discount->users->pluck('name')->join(', ') : 'همه کاربران'); ?></td>
                                <td><?php echo e($discount->products->count() ? $discount->products->pluck('title')->join(', ') : 'همه محصولات'); ?></td>
                                <td><?php echo e($discount->categories->count() ?  $discount->categories->pluck('name')->join(', ') : 'همه دسته‌ها'); ?></td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($discount->expired_at)->formatJalaliDate()); ?></td>
                                <td class="d-flex">
                                    
                                    <form action="<?php echo e(route('admin.discounts.destroy' , $discount->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger ml-1">حذف</button>
                                    </form>
                                    <a href="<?php echo e(route('admin.discounts.edit' , $discount->id)); ?>" class="btn btn-sm btn-primary ml-1">ویرایش</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>
                </div>
                <?php echo e($discounts->appends([ 'search' => request('search') ])->render()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldco/core/Modules/Discount/Resources/views/backend/all.blade.php ENDPATH**/ ?>