
@extends('frontend.layouts.app')
@section('head')
    {!! JsonLd::generate() !!}
@stop
@section('content')

  <section class="position-relative main-section-wrapper">
        <img src="/images/other/back-left.png" alt="" class="main-page-left-image hide-in-mobile">
        <img src="/images/other/back-right.png" alt="" class="main-page-right-image hide-in-mobile">
        @include('frontend.layouts.partials.search-section')

        @include('frontend.layouts.partials.category-icons')
    </section>

    @include('frontend.layouts.partials.product-carousels')

    @include('frontend.layouts.partials.icon-boxes')

@stop
@section('script')
    <script>
        $('#search-main-page').on('keyup',function(){
            $value=$(this).val();
            if ($value.length > 1) {
                $('#ajax-search-wrapper-main-page').css('display' , 'block');
                $.ajax({
                    type : 'get',
                    beforeSend: function() { $('#loading-main-page').show(); }, //Show spinner
                    complete: function() { $('#loading-main-page').hide(); }, //Hide spinner
                    url : '{{URL::to('search')}}',
                    data:{'search':$value},
                    success:function(data){
                        $('.result-main-page').html(data);
                    },
                });
            }else if ($value.length === 0) {
                $('#ajax-search-wrapper-main-page').css('display' , 'none');
            }
        })
        $(document).mouseup(function(e)
        {
            var container = $(".ajax-search-wrapper");

            // if the target of the click isn't the container nor a descendant of the container
            if (!container.is(e.target) && container.has(e.target).length === 0)
            {
                container.hide();
            }
        });
    </script>
@stop
