<?php


//check user role in users edit page
use Hekmatinasser\Verta\Verta;
use Illuminate\Validation\Rule;
use Modules\Cart\Helpers\Cart;
use Modules\Product\Entities\Price;

if (! function_exists('whatIsUserRole')){
    function whatIsUserRole($role , $user){
        foreach ($role->users as $value){
            if ($value->pivot->user_id == $user->id){
                return 'selected';
            }
        }
    }
}

//check active menu in admin page
if(! function_exists('isMenuActive')){
    function isMenuActive($route){
        if (\Illuminate\Support\Facades\Route::currentRouteName() == $route){
            return 'active';
        }
    }
}


if(! function_exists('whatIsCategories')){
    function whatIsCategories($category , $post){
        foreach ($post->categories as $val){

            if ($category->id == $val->pivot->category_id){
                return 'selected';
            }
        }
    }
}

if (!function_exists('notificationsCount')) {
    function notificationsCount($searchKey){
        $data = \Illuminate\Notifications\DatabaseNotification::where('data','LIKE',"%{$searchKey}%")->whereNull('read_at')->get();
        if (count($data)>0){
            return count($data);
        }
        return '';
    }
}
if (!function_exists('markAsReadNotifications')) {
    function markAsReadNotifications($searchKey){
        $data = \Illuminate\Notifications\DatabaseNotification::where('data','LIKE',"%{$searchKey}%")->whereNull('read_at')->get();
        if (count($data)>0){
            foreach ($data as $notification) {
                $notification->markAsRead();
            }
        }
        return '';
    }
}
if (!function_exists('persianToEngNum')){
    function persianToEngNum($string) {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $arabic = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $num = range(0, 9);
        $convertedPersianNums = str_replace($persian, $num, $string);
        $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);
        return $englishNumbersOnly;
    }
}

if (! function_exists('storeDate')) {
    function storeDate($date) {
        $string = explode('/', $date) ;
        $year = persianToEngNum($string[0]);
        $month = persianToEngNum($string[1]);
        $day = persianToEngNum($string[2]);
        $date_gregorian = Verta::getGregorian($year,$month,$day);
        return implode('-',$date_gregorian) . ' ' . '14:40:47';
    }
}
if (!function_exists('uploader')) {
    function uploader($request,$input){
        if ($file = $request->file($input)) {
            $name = time() . $file->getClientOriginalName();
            $file->move('images/' , $name);
            return $name;
        }
    }
}

if (!function_exists('str_slug')) {
    function str_slug($string) {
        return preg_replace('/\s+/u' , '-' , trim($string));
    }
}

if (!function_exists('product_gallery_uploader')) {
    function product_gallery_uploader($request,$input){
        if ($file = $request->file($input)) {
            $name = time() . $file->getClientOriginalName();
            $file->move('images/' , $name);
            return $name;
        }
    }
}


if (!function_exists('productUpdateValidator')) {
    function productUpdateValidator($request , $product) {
        $validData = $request->validate([
            'title' => 'required',
            'slug' => ['nullable', Rule::unique('products')->ignore($product)],
            'long_description' => 'nullable',
            'short_description' => 'nullable',
            'price' => 'required',
            'sale_price' => 'nullable',
            'inventory' => 'nullable',
            'is_single_sell' => 'required',
            'sku' => 'nullable',
            'brand' => 'nullable',
            'categories' => 'nullable',
            'meta_title' => 'nullable',
            'meta_keywords' => 'nullable',
            'pin_count' => 'nullable',
            'price_type' => 'nullable',
            'meta_description' => 'nullable',
            'status' => 'nullable',
            'min_order_quantity' => 'nullable',
            'english_title' => 'nullable',
            'attributes' => 'array|nullable',
            'photos.*' => [
                'nullable',
                'image'
            ],
            'new-product-photos' => 'nullable'
        ]);
        return $validData;
    }
}

if (!function_exists('productUpdate')) {
    function productUpdate($product , $validData , $request , $status) {
        $product->update([
            'title' => $validData['title'],
            'english_title' => $validData['english_title'],
            'long_description' => $validData['long_description'],
            'short_description' => $validData['short_description'],
            'sale_price' => $validData['sale_price'],
            'inventory' => $validData['inventory'],
            'is_single_sell' => $validData['is_single_sell'],
            'sku' => $validData['sku'],
            'slug' => str_slug($validData['slug']),
            'brand' => $validData['brand'],
            'meta_title' => $validData['meta_title'],
            'meta_keywords' => $validData['meta_keywords'],
            'meta_description' => $validData['meta_description'],
            'min_order_quantity' => $validData['min_order_quantity'],
            'status' => $status,
            'single_image' => $request->image
        ]);
        if($validData['min_order_quantity'] == 0 || is_null($validData['min_order_quantity'])) {
            $product->update([
               'min_order_quantity' => 1
            ]);
        }
        if ($validData['price_type'] != 'normal') {
            $priceType = \Modules\Price\Entities\Price::whereId($validData['price_type'])->first();
            $price = $priceType->price * $validData['pin_count'];
            $product->update([
                'price' => $price,
                'price_id' => $validData['price_type'],
                'pin_count' => $validData['pin_count'],
            ]);
        }else {
            $product->update([
                'price' => $validData['price'],
                'price_id' => null,
                'pin_count' => null,
            ]);
        }
    }
}


if (!function_exists('get_review_average')) {
    function get_review_average($product) {
        foreach ($product->reviews->whereNull('parent_id') as $review) {
            $reviews[] = $review->rate + 1;
        }
        $value = array_sum($reviews) / count($reviews);
        return $value;
    }
}


if (!function_exists('get_products_from_category')) {
    function get_products_from_category($category) {
        $category = \Modules\Category\Entities\Category::with('products')
            ->where('id' , $category->id)
            ->where('category_type' , \Modules\Product\Entities\Product::class)
            ->first();
        return $category->products->where('status' , 1)->sortByDesc('created_at');
    }
}
