<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Modules\Payment\Entities\Payment;
use Modules\Payment\Notifications\NewOrderAdminNotification;
use Modules\Payment\Notifications\PaymentSuccessNotification;
use Modules\User\Entities\User;

class SendNotificationsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ic-world-notification:send-notification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'check payments table every 3 minutes and sends sms to user and admin if new order made';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $payments = Payment::where('status' , 1)
            ->where('is_user_notified' , 0)
            ->where('is_user_notified' , 0)
            ->get();
        $adminUsers = User::where('is_admin' , 1)->get();
        //users notification success payment
        foreach ($payments as $payment) {
            $payment->notify(new PaymentSuccessNotification(
                $payment->order->user->phone ,
                $payment->order->order_code,
                number_format($payment->order->price),
                $payment->order->user->name . ' ' . $payment->order->user->last_name
            ));
            $payment->update([
                'is_user_notified' => 1,
            ]);
        }

        //admin new order notification
        foreach ($adminUsers as $admin) {
            foreach ($payments as $payment) {
                $payment->notify(new NewOrderAdminNotification(
                    $admin->phone ,
                    $payment->order->order_code,
                    number_format($payment->order->price),
                    $payment->order->user->name . ' ' . $payment->order->user->last_name,
                    $payment->order->address->city->name,
                    $payment->order->shipping->label
                ));

                $payment->update([
                    'is_admin_notified' => 1,
                ]);
            }
        }


    }
}
