<section class="mt-5 mb-5">
    <div class="row">
        <div class="col-lg-12">
            
            <div class="product-tabs single-product">
                <!--product navigation tab-->
                <div class="tab tab-solid">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        @if($product->long_description)
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">
                            <i class="fi fi-rr-document align-middle line-height-1"></i>
                                                            معرفی
                            </button>
                        </li>
                        @endif
                        @if($product->attributes->count())
                        <li class="nav-item" role="presentation" style="padding: 0 1rem;">
                            <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                            <i class="fi fi-rr-search-alt align-middle line-height-1"></i>
                                    مشخصات
                            </button>
                        </li>
                        @endif

                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="false">
                            <i class="fi fi-rr-comment align-middle line-height-1"></i>
                                دیدگاه ها
                            </button>
                        </li>
                    
                    </ul>
                </div>
                <!--product description tab end-->

                <!--product tab content-->
                <div class="tab-content"  id="myTabContent">
                    @if($product->long_description)
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            {!! $product->long_description !!}
                        </div>
                    @endif
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                              <div class="single-product-specification">
                                <table class="table table-sm">
                                    <tbody>
                                    @foreach($product->attributes as $attr)
                                        <tr>
                                            <td class="title">{{$attr->name}}</td>
                                            <td class="subtitle">{{$attr->pivot->value->value}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                        <div class="single-product-reviews">
                            <div class="row">
                                <div class="col-md-6">
                                    @include('product::frontend.single-product.partials.review.review' , [
        'reviews' => $product->reviews->whereNull('parent_id')->where('status' , 1),
        'reply_review' => false ])
                                </div>
                                <div class="@if($product->reviews->whereNull('parent_id')->where('status' , 1)->count()) col-md-6 @else col-md-12 @endif">
                                    <div class="send-review">
                                        <h3>نظر یا سوال شما درباره این محصول چیست؟</h3>
                                        <div class="rating-form">
                                            <span class="subtitle">امتیاز شما به این محصول:</span>
                                            <div class="review-container" id="review-container">
                                                <button class="star"><span class="stararea">★</span></button>
                                                <button class="star"><span class="stararea">★</span></button>
                                                <button class="star"><span class="stararea">★</span></button>
                                                <button class="star"><span class="stararea">★</span></button>
                                                <button class="star"><span class="stararea">★</span></button>
                                            </div>
                                        </div>
                                        <form action="{{route('review.store')}}" class="review-form" method="post">
                                            @csrf
                                            @method('post')
                                            <div class="form-group">
                                                <div class="row mb-3">
                                                    <div class="col-md-6">
                                                        <input type="text"
                                                               class="form-control br-1 @error('username') is-invalid @enderror"
                                                               name="username" placeholder="نام"
                                                               value="{{old('username')}}">
                                                        @error('username')
                                                        <span class="invalid-feedback">
                                                            <strong>
                                                                {{$message}}
                                                            </strong>
                                                        </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <textarea name="text" id="text" cols="30" rows="5"
                                                          class="form-control br-1 @error('text') is-invalid @enderror"
                                                          placeholder="نظر">{{old('text')}}</textarea>
                                                @error('text')
                                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                                @enderror
                                            </div>
                                            <input type="hidden" id="rate" name="rate">
                                            <input type="hidden" id="product_id" name="product_id"
                                                   value="{{$product->id}}">

                                            <div class="form-group">
                                                <button type="submit"
                                                        class="btn btn-default product-btn br-1 mt-3 mb-3">ارسال
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
                <!--product tab content end-->
            </div>
        </div>
    </div>
</section>
