@extends('frontend.layouts.app')
@section('head')

    <script type="application/ld+json">
    {
      "@context": "https://schema.org/",
      "@type": "Product",
      "name": "{{$product->title}}",
      "image": "{{$product->single_image}}",
      "description": "{{$product->short_description}}",
      "sku": "{{$product->sku}}",
      "mpn": "{{$product->title}}",
      "brand": {
        "@type": "Brand",
        "name": "{{$product->brand}}"
      },
     "review": {
        "@type": "Review",
        "reviewRating": {
          "@type": "Rating",
          "ratingValue": "4",
          "bestRating": "5"
        },
        "author": {
          "@type": "Organization",
          "name": "IC World Company"
        }
      },
       "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "4.5",
        "reviewCount": "47"
      },
      "offers": {
        "@type": "Offer",
        "url": "{{asset($product->slug)}}",
        "priceCurrency": "IRT",
        "price": "{{$product->price}}",
        "priceValidUntil": "2025-11-20",
        "itemCondition": "https://schema.org/UsedCondition",
        "availability": "https://schema.org/InStock",
        "seller": {
        "@type": "Organization",
         "name": "IC World Company"

         }
      }
    }
    </script>

@stop
@section('content')

    <!--Start Of Main wrapper-->
    <div class="container mt-4 mb-5">
        {{--single product nav--}}
        @include('product::frontend.single-product.partials.breadcrumb')
        {{--single product nav end--}}

        {{--single product details--}}
        @include('product::frontend.single-product.partials.product-details')
        {{--single product details end--}}

        {{--single product icon carousel--}}
        @include('product::frontend.single-product.partials.icon-box')
        {{--single product icon carousel end--}}

        {{--product tabs--}}
        @include('product::frontend.single-product.partials.tabs')
        {{--product tabs end--}}

        {{--related products--}}
        @include('product::frontend.single-product.partials.related')
        {{--related products end--}}
    </div>
    <!--End Of Main wrapper end-->

@stop
