@component('backend.layouts.components.main',['title' => 'مدیریت محصولات', 'titleBar'=>true , 'button' => 'افزودن محصول' , 'route' => 'admin.products.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">محصولات</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست محصولات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>تصویر</th>
                            <th>نام</th>
                            <th>قیمت (تومان)</th>
                            <th>موجودی</th>
                            <th>دسته بندی</th>
                            <th>نحوه نمایش در سایت</th>
                            <th>تاریخ ایجاد</th>
                            @can('manage-products')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($products as $product)

                            <tr>
                                <td>
                                    @if($product->single_image)
                                        <img src="{{$product->single_image}}" alt="" width="50" height="50">
                                    @else
                                        <img src="/backend/images/no-image.jpg" alt="" width="50" height="50">
                                    @endif
                                </td>
                                <td class="d-flex flex-column">
                                    <span style="font-weight: 600">
                                        {{$product->title}}
                                    </span>
                                    <span style="font-size: .8rem">
                                        برند:
                                        @if($product->brand)
                                            {{$product->brand}}
                                        @else
                                            وارد نشده
                                        @endif
                                    </span>
                                    @if(!is_null($product->inventory))
                                        @if($product->inventory < $product->min_order_quantity)
                                            <span class="badge badge-xs light badge-warning">موجودی کمتر از حداقل تعداد سفارش</span>
                                        @endif
                                    @endif
                                </td>
                                <td>
                                    @if(!$product->is_on_sale())
                                        {{number_format($product->price)}}
                                        تومان
                                    @else
                                        <span>
                                            <bdi style="text-decoration: line-through;">
                                               {{number_format($product->price)}}
                                                تومان
                                            </bdi>
                                        </span>
                                        {{number_format($product->sale_price)}}
                                        تومان
                                    @endif
                                </td>
                                <td>
                                    @if(is_null($product->inventory))
                                        <span class="badge badge-xs light badge-warning">انبار داری غیر فعال</span>
                                    @else
                                        {{$product->inventory}}
                                        عدد
                                    @endif
                                </td>
                                <td>
                                    @foreach($product->categories as $category)
                                        @if(count($product->categories)>1)
                                            {{$category->name . ','}}
                                        @else
                                            {{$category->name}}
                                        @endif
                                    @endforeach
                                </td>
                                <td>
                                    @if(!is_null($product->inventory))
                                        @if($product->inventory < $product->min_order_quantity)
                                            <span class="badge badge-xs light badge-warning">عدم موجودی</span>
                                        @else
                                            <span class="badge badge-xs light badge-success"> موجود</span>
                                        @endif
                                    @else
                                        <span class="badge badge-xs light badge-success">موجود</span>
                                    @endif
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($product->created_at)->formatJalaliDate()}}</td>

                                <td>
                                    <form action="{{route('admin.products.destroy', $product->id)}}" method="post"
                                          id="delete-{{$product->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.products.edit', $product->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$product->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$product->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                    <a href="{{asset('product/' . $product->slug)}}" role="button"
                                       class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$products->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
