<?php

namespace Modules\Payment\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Modules\Order\Entities\Order;
use Modules\Product\Entities\Product;

class PaymentOrderQuantity extends Pivot
{
    public function product()
    {
        return $this->belongsTo(Product::class , 'product_id' , 'id');
    }
    public function order()
    {
        return $this->belongsTo(Order::class , 'order_id' , 'id');
    }
    public function quantity()
    {
        return $this->belongsTo(Product::class , 'quantity' , 'quantity');
    }
}
