@component('backend.layouts.components.main',['title' => 'ویرایش پست','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش پست</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات پست</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="title" type="text"
                           class="form-control input-rounded @error('title') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('title') ? old('title') : $post->title}}">
                    @error('title')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#content">
                                <i class="la la-file-text ml-2"></i>
                                محتوا
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#seo">
                                <i class="la la-rocket ml-2"></i>
                                سئو
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#detail">
                                <i class="la la-dot-circle ml-2"></i>
                                جزئیات
                            </a>
                        </li>
                    </ul>
                    <form action="{{route('admin.posts.update' , $post->id)}}" method="post" id="store">
                        @csrf
                        @method('patch')
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="content" role="tabpanel">
                                <div class="pt-4">
                                    <div class="basic-form">

                                        <div class="card-body">
                                                <textarea class=" @error('body') is-invalid @enderror"
                                                          name="body" id="editor1"
                                                          required>{!! old('body') ? old('body') : $post->body !!}</textarea>
                                            @error('body')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="seo">
                                <div class="pt-4">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">سیستم نمایش در گوگل</h4>
                                            <img src="{{asset('/images/google-icon.png')}}"
                                                 style="width: 50px; height: auto">
                                        </div>
                                        <div class="card-body">
                                            <div class="results">
                                                <div class="ind">
                                                    <a class="link" id="g-link" href="#">
                                                        @if($post->meta_title != null)
                                                            {{$post->meta_title}}
                                                        @else
                                                            عنوان متا یک | عنوان متا 2 | نام وب سایت
                                                        @endif
                                                    </a>
                                                    <br/>
                                                    <a class="url" href="#">
                                                        {{asset('/')}} &#9662;
                                                    </a>
                                                    <p id="g-desc" class="desc">
                                                        @if($post->meta_description != null)
                                                            {{$post->meta_description}}
                                                        @else
                                                            لطفا توضیحاتی را درباره ی این پست بنویسید
                                                        @endif
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">عنوان متا</label>
                                        <div class="col-sm-9">
                                            <input type="text" id="meta-title" name="meta_title"
                                                   class="form-control input-rounded @error('meta_title') is-invalid @enderror"
                                                   placeholder="عنوان متا"
                                                   value="{{old('meta_title') ? old('meta_title') : $post->meta_title}}">
                                            @error('meta_title')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">توضیحات متا</label>
                                        <div class="col-sm-9">
                                            <textarea placeholder="توضیحات متا" name="meta_description"
                                                      class="form-control @error('meta_description') is-invalid @enderror"
                                                      rows="4"
                                                      id="meta-desc">{{old('meta_description') ? old('meta_description') : $post->meta_description}}</textarea>
                                            @error('meta_description')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">کلمات کلیدی</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="meta_keywords"
                                                   class="form-control input-rounded @error('meta_keywords') is-invalid @enderror"
                                                   placeholder="مثلا: طراحی سایت , طراحی سایت من"
                                                   value="{{old('meta_keywords') ? old('meta_keywords') : $post->meta_keywords}}">
                                            @error('meta_keywords')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">نوع پست</label>
                                        <div class="col-sm-9">
                                            <div class="dropdown bootstrap-select form-control default-select dropup">
                                                <select name="meta_type"
                                                        class="form-control default-select input-rounded @error('meta_type') is-invalid @enderror"
                                                        id="sel1"
                                                        tabindex="-98">
                                                    <option value="">انتخاب کنید</option>
                                                    <option value="Article"
                                                            @if($post->meta_type == 'Article') selected @endif>مقاله
                                                    </option>
                                                    <option value="NewsArticle"
                                                            @if($post->meta_type == 'NewsArticle') selected @endif>مقاله
                                                        خبری
                                                    </option>
                                                    <option value="VideoObject"
                                                            @if($post->meta_type == 'VideoObject') selected @endif>ویدیو
                                                    </option>
                                                </select>
                                                @error('meta_type')
                                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                                @enderror
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="detail">
                                <div class="pt-4">
                                    <p class="text-justify">
                                        <i class="fa fa-circle text-blue ml-1"></i>
                                        لینک به صورت پیش فرض از عنوان نوشته ساخته میشود، درصورتی که قصد تغییر آن را
                                        دارید در این باکس لینک را وارد کنید
                                    </p>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">لینک</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="slug"
                                                   class="form-control input-rounded @error('slug') is-invalid @enderror"
                                                   placeholder="لینک"
                                                   value="{{old('slug') ? old('slug') : $post->slug}}">
                                            @error('slug')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">تصویر کاور</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="text" id="image_label" class="form-control"
                                                       value="{{old('image') ? old('image') : $post->image}}"
                                                       name="image"
                                                       aria-label="Image" aria-describedby="button-image"
                                                       style="direction: ltr;border-radius: 0 50px 50px 0">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-info" type="button"
                                                            id="button-image">
                                                        انتخاب
                                                    </button>
                                                </div>
                                            </div>
                                            @error('image')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.posts.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال ویرایش ها، روی دکمه "به روز رسانی" کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    در صورتی که میخواهید پست منتشر شده اما در سایت نمایش داده نشود وضعیت را در حالت خاموش قرار دهید.
                </p>

                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    پیوند یکتا:
                    <br>
                </p>
                <p style="direction: ltr">
                    <a style="color:dodgerblue;" href="{{asset($post->slug)}}">{{asset($post->slug)}}</a>
                </p>
                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-control custom-switch toggle-switch text-right mr-4 mb-2">
                            <input type="checkbox" class="custom-control-input" id="customSwitch12" form="store"
                                   name="status" @if($post->status) checked @endif>
                            <label class="custom-control-label fs-14 text-black pr-2" for="customSwitch12">وضعیت</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>

                </div>

            </div>
        </div>
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">دسته بندی</h4>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    لطفا دسته بندی مورد نظر خود را از باکس زیر انتخاب کنید
                </p>

                <select name="categories[]" multiple
                        class="form-control default-select input-rounded" form="store">
                    @include('category::backend.posts.partials.categories-dropdown-edit' ,
                             [
                                 'categories' => $categories ,
                                 'level' => 0,
                                 'post' => $post
                                 ])
                </select>


            </div>
        </div>
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">تصویر</h4>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای تغییر یا افزودن تصویر میتوانید از منوی "جزئیات" اقدام نمایید
                </p>
                <div class=" text-center">
                <img src="{{$post->image}}" style="border-radius: 50px 50px 50px 50px; width: 350px; height: auto">
                </div>
            </div>
        </div>
    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>

@stop

@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
@stop
@endcomponent
