@component('backend.layouts.components.main',['title' => 'افزودن دسته بندی','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن دسته بندی جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات دسته بندی</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.categories-products.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام</label>
                            <div class="col-sm-9">
                                <input name="name" type="text"
                                       class="form-control input-rounded @error('name') is-invalid @enderror"
                                       placeholder="نام" value="{{old('name')}}">
                                @error('name')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">لینک</label>
                            <div class="col-sm-9">
                                <input name="slug" type="text"
                                       class="form-control input-rounded @error('slug') is-invalid @enderror"
                                       placeholder="لینک" value="{{old('slug')}}">
                                @error('slug')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دسته بندی مادر</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="parent_id"
                                            class="form-control default-select input-rounded @error('parent_id') is-invalid @enderror"
                                            id="sel1" tabindex="-98">
                                        <option value="">ندارد</option>
                                        @include('category::backend.products.partials.categories-dropdown' ,
                                        [
                                            'categories' => $categories ,
                                            'level' => 0,
                                            'edit' => false
                                            ])
                                    </select>
                                </div>

                            </div>

                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">کلمات کلیدی</label>
                            <div class="col-sm-9">
                                <input type="text" name="keywords"
                                       class="form-control input-rounded @error('keywords') is-invalid @enderror"
                                       placeholder="مثلا: طراحی سایت , طراحی سایت من"
                                       value="{{old('keywords')}}">
                                @error('keywords')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">تصویر دسته بندی</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <input type="text" id="image_label" class="form-control" name="image"
                                           aria-label="Image" aria-describedby="button-image"
                                           style="direction: ltr;border-radius: 0 50px 50px 0">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-info" type="button"
                                                id="button-image">
                                            انتخاب
                                        </button>
                                    </div>
                                </div>
                                @error('image')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>

                        <label class="col-sm-3 col-form-label">توضیحات دسته بندی (برای سئوی بهتر)</label>

                        <div class="basic-form">

                                <div class="card-body">
                                                <textarea class="@error('cat_desc') is-invalid @enderror"
                                                          name="cat_desc" id="editor1" required>{{old('cat_desc')}}</textarea>
                                    @error('cat_desc')
                                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                    @enderror
                                </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.categories-products.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد دسته بندی جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-save"></i>
                        ساختن
                    </button>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}
@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>

    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>

@stop
@endcomponent
