<?php

namespace Modules\Cart\Http\Controllers\Front;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Address\Entities\City;
use Modules\Cart\Helpers\Cart;
use Modules\Shipping\Entities\Shipping;

class CheckoutController extends Controller
{
    use SEOTools;

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()->setTitle('صورتحساب');
        $cities = City::all();
        $shippings = Shipping::all();
        $cookieCart = Cart::instance('cart-ic-world');
        $cartItems = $cookieCart->all();
        foreach ($cartItems as $cartItem) {
            if (!is_null($cartItem['product']->inventory)){
                if ($cartItem['product']->inventory === 0 || $cartItem['quantity'] > $cartItem['product']->inventory) {
                    $productWithZeroInventory[] = $cartItem['product'];
                    $cookieCart->delete($cartItem['id']);
                }
            }
        }
        if (isset($productWithZeroInventory)) {
            if (count($productWithZeroInventory) > 0) {
                return view('cart::frontend.cart' , compact(['productWithZeroInventory' , 'cookieCart']));
            }
        }
        return view('cart::frontend.checkout' , compact(['cities' , 'cookieCart' , 'shippings']));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('cart::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('cart::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('cart::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
