<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "content" div.
 *
 * @package WordPress
 * @subpackage vt-feminine
 * @since vt-feminine 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
	<meta name="viewport" content="width=device-width, initial-scale=1"/>
	<link rel="profile" href="http://gmpg.org/xfn/11" />
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php
	//wp_body_open hook from WordPress 5.2
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	}else { 
		do_action( 'wp_body_open' ); 
	}
	?>
    <div id="wrapper">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'vt-feminine' ); ?></a>

        <div class="topbar">
            <div class="container">
                <?php
                    wp_nav_menu( array (
                        'container'		 => false,
                        'theme_location' => 'topbar',
						'depth'			 => 1,
						'menu_class'	 => 'topbar-menu pull-left',
						'fallback_cb' 	 => 'vt_feminine_navigation_fallback',
                    ) );
                ?>
				<?php get_template_part('template-parts/social', 'topbar'); ?>
				
            </div>
        </div><!-- topbar -->
		
		<header id="masthead" class="site-header" <?php if( has_header_image() ) : ?> style="background-image: url(<?php echo esc_url( get_header_image() ); ?>)" <?php endif; ?>>
			<div class="container">
				<div class="site-branding">
	
					<?php
					the_custom_logo();
					if (is_front_page() && is_home()) :
						?>
						<h1 class="site-title">
							<a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
						</h1>
					<?php
					else :
						?>
						<p class="site-title">
							<a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
						</p>
					<?php
					endif;
					$description = get_bloginfo( 'description', 'display' );
					if ( $description || is_customize_preview() ) : ?>
						<h2 class="site-description"><?php echo esc_html($description); ?></h2>
					<?php endif; ?>
						
				</div><!-- .site-branding -->
				
			</div><!-- container -->
			
			<?php if (get_theme_mod('vt_feminine_header_overlay', 1) == 1) : ?>
				<?php if ( get_header_image() ) { ?><div class="mask"></div><?php } ?>
			<?php endif; ?>
			
        </header><!-- #masthead -->

		<nav id="site-navigation" class="main-navigation" aria-label="<?php esc_attr_e( 'Main Menu', 'vt-feminine' ); ?>">
			<div id="primary-menu" class="container">
			
			  <?php if ( has_nav_menu( 'primary' ) ) {?>
				<button class="nav-toggle" aria-controls="site-navigation" aria-expanded="false" type="button">
					<div class="bars">
						<div class="bar"></div>
						<div class="bar"></div>
						<div class="bar"></div>
					</div>
					<span class="dashicons" aria-hidden="true"></span>
				</button><!-- /nav-toggle -->
			  <?php } ?>

				<?php
				  if ( has_nav_menu( 'primary' ) ) {
					wp_nav_menu( array(
						'theme_location' => 'primary',
						'container' 	 => '',
						'menu_class'	 => 'primary-menu vtmenu nav-menu',
						'menu_id' 		 => '',
						'fallback_cb' 	 => 'vt_feminine_navigation_fallback',
					) );
				} else {
				?>
				
				<div class="menu-modal-inner modal-inner">
					<ul class="vtmenu li">
					  <?php if ( current_user_can( 'edit_theme_options' ) ) { ?>
						<li><a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ); ?>"><?php echo esc_html__( 'Add menu for theme location: Primary Menu', 'vt-feminine' );?></a></li>
					<?php } ?>
					</ul>
				</div>
				
				<?php } ?>

			</div>
		</nav><!-- #navigation -->
		
		<div id="content" class="container">
		
		  <?php
			/**
			 * Hook -  vt_feminine_slider_1
			 *
			 * @hooked vt_feminine_slider - 20
			 */
			do_action('vt_feminine_slider_1');
		   ?>