<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package vt-feminine
 */
 
if( ! function_exists( 'vt_feminine_admin_notice' ) ) :
/**
 * Addmin notice for getting started page
*/
function vt_feminine_admin_notice(){
    global $pagenow;
    $theme_args      = wp_get_theme();
    $meta            = get_option( 'vt_feminine_admin_notice' );
    $name            = $theme_args->__get( 'Name' );
    $current_screen  = get_current_screen();
    
    if( 'themes.php' == $pagenow && !$meta ){
        
        if( $current_screen->id !== 'dashboard' && $current_screen->id !== 'themes' ){
            return;
        }

        if( is_network_admin() ){
            return;
        }

        if( ! current_user_can( 'manage_options' ) ){
            return;
        } ?>

        <div class="welcome-message notice notice-info">
            <div class="notice-wrapper">
                <div class="notice-text">
                    <h3><?php esc_html_e( 'Congratulations!', 'vt-feminine' ); ?></h3>
                    <p><?php printf( __( '%1$s is now installed and ready to use. Click below to see theme documentation, plugins to install and other details to get started.', 'vt-feminine' ), esc_html( $name ) ); ?></p>
                    <p><a href="<?php echo esc_url( admin_url( 'themes.php?page=vy-feminine-welcome' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Go to the getting started.', 'vt-feminine' ); ?></a></p>
                    <p class="dismiss-link"><strong><a href="?vt_feminine_admin_notice=1"><?php esc_html_e( 'Dismiss', 'vt-feminine' ); ?></a></strong></p>
                </div>
            </div>
        </div>
    <?php }
}
endif;
add_action( 'admin_notices', 'vt_feminine_admin_notice' );

if( ! function_exists( 'vt_feminine_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function vt_feminine_update_admin_notice(){
    if ( isset( $_GET['vt_feminine_admin_notice'] ) && $_GET['vt_feminine_admin_notice'] = '1' ) {
        update_option( 'vt_feminine_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'vt_feminine_update_admin_notice' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function vt_feminine_pingback_header() {
	
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'vt_feminine_pingback_header' );

/**
 * Slider settings
 */
function vt_feminine_slider_config() {
	
	if ( get_theme_mod('vt_feminine_featured_slider', 0) == 1) {
	
		get_template_part('template-parts/featured', 'slider'); 

	}
}
add_action('vt_feminine_slider_1','vt_feminine_slider_config',20);

/**
 * Display the first (single) category of post.
 */
if ( ! function_exists( 'vt_feminine_first_category' ) ) :
	function vt_feminine_first_category() {
		
		$category 		= get_the_category();
		if ($category) {
		  echo '<a href="' . esc_url(get_category_link( $category[0]->term_id ) ) . '">' . esc_html( $category[0]->name ) . '</a>';
		}
		
	}
endif;

/**
 * Fallback callback for primary navigation menu.
 */
if ( ! function_exists( 'vt_feminine_navigation_fallback' ) ) {

    function vt_feminine_navigation_fallback() {
        ?>
        <ul class="topbar-menu pull-left">
            <?php 
            wp_list_pages( array( 
                'title_li' => '', 
                'depth' => 4,
            ) ); 
            ?>
        </ul><!-- .primary-menu -->
        <?php    
    }
}

/**
 * Scroll to top
 */
function vt_feminine_scroll_to_top() {
	
	if (get_theme_mod('button_up', 0) == 0){
		
?>
	<div id="backtotop">
		<span><?php esc_html_e('Back to top', 'vt-feminine'); ?></span>
	</div>
	
<?php
}}
add_action('wp_footer', 'vt_feminine_scroll_to_top');