<?php
/**
 * Defines customizer options
 *
 * @package vt-feminine 
 */

function customizer_library_vt_feminine_options() {

	// Theme defaults
	$primary_color = '#ee7575';
	$header_color = '#535353';
	$header_search_bg_color = '#3c4852';
	$widget_title_boder_color = '#eb5424';
	$pagination_bg_color = '#eb5424 ';

	// Stores all the controls that will be added
	$options = array();

	// Stores all the sections to be added
	$sections = array();

	// Stores all the panels to be added
	$panels = array();

	// Adds the sections to the $options array
	$options['sections'] = $sections;

	/**-----------------
	 * Theme Settings
	 -----------------*/
	$panel = 'vt-panel-layout';
	
    $panels[] = array(
        'id' => $panel,
        'title' => __( 'Theme Settings', 'vt-feminine' ),
        'priority' => '30'
    );
	

	/**-----------------
	 * Header Settings
	 -----------------*/
	$section = 'header_image';
    
	$sections[] = array(
		'id' => $section,
		'title' => __( 'Header', 'vt-feminine' ),
		'priority' => '20',
		'panel' => $panel
	);
	
	$options['vt_feminine_header_social'] = array(
		'id' => 'vt_feminine_header_social',
		'label'   => __( 'Display Header Social Icons', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1
	);
	$options['vt_feminine_header_search'] = array(
		'id' => 'vt_feminine_header_search',
		'label'   => __( 'Display Header Search', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1
	);
	$options['vt_feminine_header_overlay'] = array(
		'id' => 'vt_feminine_header_overlay',
		'label'   => __( 'Enable Overlay', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1
	);
	
	// Social Media Settings
    $section = 'vt-site-layout-section-socmed';

    $sections[] = array(
        'id' => $section,
        'title' => __( 'Social Media Profile', 'vt-feminine' ),
		'description'  => __('Enter the full url your public social media profile. use <strong><em>https://</em></strong>', 'vt-feminine'),
        'priority' => '30',
		'panel' => $panel
    );
	
    $options['vt_feminine_facebook'] = array(
        'id' => 'vt_feminine_facebook',
        'label'   => __( 'Facebook', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'url',
        'default' => ''
    );
	$options['vt_feminine_twitter'] = array(
        'id' => 'vt_feminine_twitter',
        'label'   => __( 'Twitter', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'url',
        'default' => ''
    );
	$options['vt_feminine_linkedin'] = array(
        'id' => 'vt_feminine_linkedin',
        'label'   => __( 'Linkedin', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'url',
        'default' => ''
    );
	$options['vt_feminine_pinterest'] = array(
        'id' => 'vt_feminine_pinterest',
        'label'   => __( 'Pinterest', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'url',
        'default' => ''
    );
	$options['vt_feminine_instagram'] = array(
        'id' => 'vt_feminine_instagram',
        'label'   => __( 'Instagram', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'url',
        'default' => ''
    );
	$options['vt_feminine_youtube'] = array(
        'id' => 'vt_feminine_youtube',
        'label'   => __( 'Youtube', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'url',
        'default' => ''
    );
	
	// Featured slider
    $section = 'vt-section-slider';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Featured Slider', 'vt-feminine' ),
		'priority' => '40',
		'panel' => $panel
	);
	
	$options['vt_feminine_featured_slider'] = array(
		'id' => 'vt_feminine_featured_slider',
		'label'   => __( 'Enable Featured Slider', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 0,
		'priority' => '5'
	);	
	
	$options['vt_feminine_featured_slider_slides'] = array(
        'id' => 'vt_feminine_featured_slider_slides',
        'label'   => __( 'Amount of Slides', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'number',
        'default' => 5,
		'priority' => '7'
    );
	
	/**-----------------
	 * Blog Settings
	 -----------------*/
	$section = 'theme-settings';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Blog Settings', 'vt-feminine' ),
		'priority' => '50',
		'panel' => $panel
	);

    $choices = array(
		'layout-grid' => __('Grid Layout', 'vt-feminine'),
		'layout-standard' => __('Standard Layout', 'vt-feminine'),
			
    );
    $options['blog-page-layout'] = array(
        'id' => 'blog-page-layout',
        'label'   => __( 'Blog Page Layout', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'select',
        'choices' => $choices,
        'default' => 'layout-grid'
    );
	
	$choices = array(
		'layout-grid' => __('Grid Layout', 'vt-feminine'),
		'layout-standard' => __('Standard Layout', 'vt-feminine'),
			
    );
    $options['archive-page-layout'] = array(
        'id' => 'archive-page-layout',
        'label'   => __( 'Archive Page Layout', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'select',
        'choices' => $choices,
        'default' => 'layout-grid'
    );
	
	$options['vt_feminine_entry_excerpt'] = array(
		'id' => 'vt_feminine_entry_excerpt',
		'label'   => __( 'Number of words to show on excerpt', 'vt-feminine' ),
		'section' => $section,
        'type'    => 'number',
        'default' => 38,
        'description' => __( 'Default: 38', 'vt-feminine' )		
	);
	
	$options['vt_feminine_sticky_sidebar'] = array(
		'id' => 'vt_feminine_sticky_sidebar',
		'label'   => __( 'Enable Sticky Sidebar', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1,
	);
	$options['button_up'] = array(
		'id' => 'button_up',
		'label'   => __( 'Enable "BackToTop" button', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1,
	);
	
	/**-----------------
	 * Single Posts 
	 -----------------*/
	$section = 'vt_feminine_single_post_section';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Single Post', 'vt-feminine' ),
		'priority' => '60',
		'panel' => $panel
	);
	
	$options['single-tags-on'] = array(
		'id' => 'single-tags-on',
		'label'   => __( 'Display Post Tags', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1,
	);
	$options['single-post-nav'] = array(
		'id' => 'single-post-nav',
		'label'   => __( 'Display Post Nav', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1,
	);
	$options['related-posts-on'] = array(
		'id' => 'related-posts-on',
		'label'   => __( 'Display Related posts', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 1,
	);
	
	// Footer Settings
    $section = 'vt-site-layout-section-footer';

    $sections[] = array(
        'id' => $section,
        'title' => __( 'Footer', 'vt-feminine' ),
        'priority' => '110',
		'panel' => $panel
    );
	$options['feminine_footer_logo'] = array(
		'id' => 'feminine_footer_logo',
		'label'   => __( 'Footer Logo', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'upload',
		'default' => ''
	);
	$options['vt_feminine_footer_social'] = array(
		'id' => 'vt_feminine_footer_social',
		'label'   => __( 'Display Social Profile', 'vt-feminine' ),
		'section' => $section,
		'type'    => 'ios',
		'default' => 0,
	);
	
	/**-----------------
	 * Color Settings
	 -----------------*/
    $panel = 'vt-colors-settings';

    $panels[] = array(
        'id' => $panel,
        'title' => __( 'Color Settings', 'vt-feminine' ),
        'priority' => '80'
    );
    
    $section = 'colors';
	
	$options['vt_feminine_color_scheme'] = array(
        'id' => 'vt_feminine_color_scheme',
        'label'   => __( 'Color Scheme', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
        'default' => $primary_color,
    );
	
    $options['vt_feminine_header_bg_color'] = array(
        'id' => 'vt_feminine_header_bg_color',
        'label'   => __( 'Header Background', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
        'default' => '',
    );
	$options['vt_feminine_site_title_color'] = array(
        'id' => 'vt_feminine_site_title_color',
        'label'   => __( 'Site Title Color', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
		'default' => $header_color,
    );
	$options['vt_feminine_site_desc_color'] = array(
        'id' => 'vt_feminine_site_desc_color',
        'label'   => __( 'Site Tagline Color', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
        'default' => '#757575'
    );
	$options['vt_feminine_nav_bg_color'] = array(
        'id' => 'vt_feminine_nav_bg_color',
        'label'   => __( 'Menu Background', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
        'default' => '#f9f9f9'
    );
	
	$options['menu_link_color'] = array(
        'id' => 'menu_link_color',
        'label'   => __( 'Menu Link Color', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
		'default' => '#535353'
    );
	
	$options['menu_link_hover_color'] = array(
        'id' => 'menu_link_hover_color',
        'label'   => __( 'Menu Link Hover Color', 'vt-feminine' ),
        'section' => $section,
        'type'    => 'color',
        'default' => $primary_color,
    );
	
	
	// Adds the sections to the $options array
	$options['sections'] = $sections;

	// Adds the panels to the $options array
	$options['panels'] = $panels;

	$customizer_library = Customizer_Library::Instance();
	$customizer_library->add_options( $options );

	// To delete custom mods use: customizer_library_remove_theme_mods();

}
add_action( 'init', 'customizer_library_vt_feminine_options' );

function vt_feminine_register_theme_customizer( $wp_customize ){
	
    // Featured Cat
	$wp_customize->add_setting( 'vt_feminine_featured_cat', array(
		'capability'        => 'edit_theme_options',
		'transport' 		=> 'refresh',
		'default'			=> '',
		'sanitize_callback' => 'absint'
	) );
	
	$wp_customize->add_control(
		new WP_Customize_Category_Control(
			$wp_customize,
			'vt_feminine_featured_cat',
			array(
				'label'			=> __('Select Featured Category', 'vt-feminine'),
				'description'	=> __('Choose category to show the slider.', 'vt-feminine'),
				'settings' 	 	=> 'vt_feminine_featured_cat',
				'section'		=> 'vt-section-slider',
				'type'      	=> 'category_dropdown',
				'priority' 		=> '6'
			)
		)
	);
	
}
add_action( 'customize_register', 'vt_feminine_register_theme_customizer' );