<?php

    if ( avventura_lite_setting('vagando_enable_featured_posts', true) == true ) :

        $featured_posts_enabled = avventura_lite_setting('vagando_enable_featured_posts_only_first_page_pagination', true);

        if (
            (
                $featured_posts_enabled == true && 
                get_query_var('paged') <= 1
            ) ||
            $featured_posts_enabled == false
        ) :

    ?>

        <section class="featured-posts-section">

            <div class="container">
                
                <div class="row">
                    
                    <div class="col-md-12">

                        <div class="featured-posts-grid">

                            <div class="featured-posts-main-column">
                                
                                <?php

                                    $section_title = avventura_lite_setting('vagando_main_column_label', esc_html__( 'Recent', 'vagando' ));
                                    $slider_transition = avventura_lite_setting('vagando_main_column_slider_transition', 'fade');

                                    $col_cx = array(
                                        'post_type' => 'post',
                                        'posts_per_page' => intval(avventura_lite_setting('vagando_main_column_posts_limit', 5)),
                                        'ignore_sticky_posts' => true,
                                        'orderby' => avventura_lite_setting('vagando_main_column_posts_orderby', 'date'),
                                        'order' => avventura_lite_setting('vagando_main_column_posts_sort_order', 'desc'),
                                    );

                                    if ( is_numeric(avventura_lite_setting('vagando_main_column_posts_category')) ) :
                                        $col_cx['cat'] = avventura_lite_setting('vagando_main_column_posts_category');
                                    endif;
                            
                                    vagando_horizontal_featured_posts_slideshow($col_cx, $section_title, $slider_transition);
                                
                                ?>

                            </div>

                            <div class="featured-posts-secondary-column">

                                <?php

                                    $section_title = avventura_lite_setting('vagando_secondary_column_label', esc_html__( 'Oldest post', 'vagando' ));

                                    $col_sx = array(
                                        'post_type' => 'post',
                                        'posts_per_page' => intval(avventura_lite_setting('vagando_secondary_column_posts_limit', 8)),
                                        'ignore_sticky_posts' => true,
                                        'orderby' => avventura_lite_setting('vagando_secondary_column_posts_orderby', 'date'),
                                        'order' => avventura_lite_setting('vagando_secondary_column_posts_sort_order', 'asc'),
                                    );

                                    if ( is_numeric(avventura_lite_setting('vagando_secondary_column_posts_category')) ) :
                                        $col_sx['cat'] = avventura_lite_setting('vagando_secondary_column_posts_category');
                                    endif;
                                
                                    vagando_vertical_featured_posts_slideshow($col_sx, $section_title);

                                ?>

                            </div>

                            <div class="featured-posts-side-column">

                                <?php

                                    $section_title = avventura_lite_setting('vagando_side_column_label', esc_html__( 'Popular', 'vagando' ));

                                    $col_dx = array(
                                        'post_type' => 'post',
                                        'posts_per_page' => intval(avventura_lite_setting('vagando_side_column_posts_limit', 8)),
                                        'ignore_sticky_posts' => true,
                                        'orderby' => avventura_lite_setting('vagando_side_column_posts_orderby', 'comment_count'),
                                        'order' => avventura_lite_setting('vagando_side_column_posts_sort_order', 'desc'),
                                    );

                                    if ( is_numeric(avventura_lite_setting('vagando_side_column_posts_category')) ) :
                                        $col_dx['cat'] = avventura_lite_setting('vagando_side_column_posts_category');
                                    endif;
                                
                                    vagando_vertical_list_featured_posts_slideshow($col_dx, $section_title);

                                ?>

                            </div>

                        </div>
                    
                    </div>

                </div>

            </div>

        </section>

<?php

        endif;


    endif;

?>