/*
 * jQuery theme functions
 * https://www.themeinprogress.com
 *
 * Copyright 2024, ThemeinProgress
 * Licensed under MIT license
 * https://opensource.org/licenses/mit-license.php
 */

jQuery.noConflict()(function($){

	"use strict";

/* ===============================================
   Newsticker
   =============================================== */

	$('.news-ticker-marquee-init').marquee({
		duration: 150000,
		pauseOnHover : true,
		startVisible: true,
		delayBeforeStart: 0,
		duplicated:true

	});

/* ===============================================
   Scroll sidebar
   =============================================== */

	function vagando_scroll_menu() {

		if ( $(window).width() < 992 ) {

			$("#scroll-sidebar").niceScroll(".wrap", {
				cursorwidth: "10px",
				cursorborder: "1px solid #fff",
				railpadding: {
					top: 0,
					left: 0,
					bottom: 0,
					right: 0
				}
			});

			$('nav#mobilemenu ul > li > a').click(function(){
				setTimeout(function(){
				  $("#scroll-sidebar").getNiceScroll().resize();
				}, 500);
			});

		} else {
			$("#scroll-sidebar").getNiceScroll().remove();
		}

		if ( $(window).width() < 992 ) {

			$("#menu-wrapper .mobile-navigation").click(function() {
	
				$('#overlay-body').fadeIn(600).addClass('visible');
				$('body').addClass('overlay-active').addClass('no-scrolling');
				$('#wrapper').addClass('open-sidebar');
	
				$('#sidebar-wrapper').css({
				  display: "block"
				});
	
				$('#scroll-sidebar').animate({
				  left: "0px"
				}, 400);
	
				setTimeout(function(){
					$('#scroll-sidebar a.mobile-navigation').focus();
				}, 100);
	
			});

			$("#overlay-body").swipe({

				swipeLeft:function() {

					$('#overlay-body').fadeOut(600);
					$('body').removeClass('overlay-active').removeClass('no-scrolling');
					$('#wrapper').removeClass('open-sidebar');
					
					$('#scroll-sidebar').animate({
					  left: "-300px"
					}, 200);
	
					setTimeout(function(){
						$('#sidebar-wrapper').css({
						  display: "none"
						});
					}, 200);
				},
				
				threshold : 10

			});

			$("#sidebar-wrapper .mobile-navigation").click(function() {
				
				$('#overlay-body').fadeOut(600);
				$('body').removeClass('overlay-active').removeClass('no-scrolling');
				$('#wrapper').removeClass('open-sidebar');

				$('#scroll-sidebar').animate({
				  left: "-300px"
				}, 200);

				setTimeout(function(){
					$('#sidebar-wrapper').css({
					  display: "none"
					});
				}, 200);

			});

		}

	}

	$(document).ready(function(){
		vagando_scroll_menu();
	});

	$(window).resize(function(){
		vagando_scroll_menu();
	});

	$(window).load(function() {
		vagando_scroll_menu();
	});
	
/* ===============================================
   Featured posts orizzontal slideshow
   ============================================= */

   	$(document).ready(function(){

		var slider_transition = $('.horizontal-featured-posts-slideshow').attr('data-transition') === 'fade' ? true : false;

		$('.horizontal-featured-posts-slideshow').not('.slick-initialized').slick({
			centerMode: false,
			slidesToShow: 1,
			adaptiveHeight:false,
			fade: slider_transition,
			nextArrow: '<div class="next-arrow"><span class="dashicons dashicons-arrow-right-alt2"></span></div>',
			prevArrow: '<div class="prev-arrow"><span class="dashicons dashicons-arrow-left-alt2"></span></div>',
			appendArrows: $(this).find('.horizontal-featured-posts-navigation'),
		});

	});

/* ===============================================
   Featured posts vertical carousel
   ============================================= */

	$(document).ready(function(){

		$('.vertical-featured-posts-section').each(function(){

			var vertical_featured_posts_slideshow = $(this).children('.vertical-featured-posts-slideshow');
			var n_items = $(this).children('.vertical-featured-posts-slideshow').hasClass('vertical-overlay-carousel') ? 4 : 6;
			var n_items_laptop = $(this).children('.vertical-featured-posts-slideshow').hasClass('vertical-overlay-carousel') ? 4 : 6;
			var n_items_mobile = $(this).children('.vertical-featured-posts-slideshow').hasClass('vertical-overlay-carousel') ? 2 : 3;

			vertical_featured_posts_slideshow.not('.slick-initialized').slick({
				
				slidesToShow: n_items,
				slidesToScroll: 1,
				fade: false,
				vertical: true,
				infinite: false,
				verticalSwiping: true,
				nextArrow: '<div class="next-arrow"><span class="dashicons dashicons-arrow-up-alt2"></span></div>',
				prevArrow: '<div class="prev-arrow"><span class="dashicons dashicons-arrow-down-alt2"></span></div>',
				appendArrows: $(this).find('.vertical-featured-posts-navigation'),
				responsive: [
					{
						breakpoint: 1170,
						settings: {
							slidesToShow: n_items_laptop,
						}
					},
					{
						breakpoint: 993,
						settings: {
							slidesToShow: n_items_mobile,
							slidesToScroll: 1,
						}
					},
					{
						breakpoint: 601,
						settings: {
							slidesToShow: 1,
							slidesToScroll: 1,
						}
					}

				]
		
			});
			
		});

	});

});